/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface;

import io.github.albertus82.util.IOUtils;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.SortOrder;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class ImageUtils {
    private ImageUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static org.eclipse.swt.graphics.Image resize(org.eclipse.swt.graphics.Image image, float scale) {
        int w = image.getBounds().width;
        int h = image.getBounds().height;
        BufferedImage img = ImageUtils.convertToAWT(image.getImageData());
        int newWidth = Math.round(scale * (float)w);
        int newHeight = Math.round(scale * (float)h);
        int mode = scale < 1.0f ? 16 : 4;
        Image scaledImage = img.getScaledInstance(newWidth, newHeight, mode);
        img = new BufferedImage(newWidth, newHeight, 1);
        img.getGraphics().drawImage(scaledImage, 0, 0, null);
        ImageData imageData = ImageUtils.convertToSWT(img);
        return new org.eclipse.swt.graphics.Image((Device)Display.getDefault(), imageData);
    }

    public static BufferedImage convertToAWT(ImageData data) {
        PaletteData palette = data.palette;
        if (palette.isDirect) {
            DirectColorModel colorModel = new DirectColorModel(data.depth, palette.redMask, palette.greenMask, palette.blueMask);
            BufferedImage bufferedImage = new BufferedImage(colorModel, ((ColorModel)colorModel).createCompatibleWritableRaster(data.width, data.height), false, null);
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[3];
            for (int y = 0; y < data.height; ++y) {
                for (int x = 0; x < data.width; ++x) {
                    int pixel = data.getPixel(x, y);
                    RGB rgb = palette.getRGB(pixel);
                    pixelArray[0] = rgb.red;
                    pixelArray[1] = rgb.green;
                    pixelArray[2] = rgb.blue;
                    raster.setPixels(x, y, 1, 1, pixelArray);
                }
            }
            return bufferedImage;
        }
        RGB[] rgbs = palette.getRGBs();
        byte[] red = new byte[rgbs.length];
        byte[] green = new byte[rgbs.length];
        byte[] blue = new byte[rgbs.length];
        for (int i = 0; i < rgbs.length; ++i) {
            RGB rgb = rgbs[i];
            red[i] = (byte)rgb.red;
            green[i] = (byte)rgb.green;
            blue[i] = (byte)rgb.blue;
        }
        IndexColorModel colorModel = data.transparentPixel != -1 ? new IndexColorModel(data.depth, rgbs.length, red, green, blue, data.transparentPixel) : new IndexColorModel(data.depth, rgbs.length, red, green, blue);
        BufferedImage bufferedImage = new BufferedImage(colorModel, ((ColorModel)colorModel).createCompatibleWritableRaster(data.width, data.height), false, null);
        WritableRaster raster = bufferedImage.getRaster();
        int[] pixelArray = new int[1];
        for (int y = 0; y < data.height; ++y) {
            for (int x = 0; x < data.width; ++x) {
                int pixel;
                pixelArray[0] = pixel = data.getPixel(x, y);
                raster.setPixel(x, y, pixelArray);
            }
        }
        return bufferedImage;
    }

    public static ImageData convertToSWT(BufferedImage bufferedImage) {
        if (bufferedImage.getColorModel() instanceof DirectColorModel) {
            DirectColorModel colorModel = (DirectColorModel)bufferedImage.getColorModel();
            PaletteData palette = new PaletteData(colorModel.getRedMask(), colorModel.getGreenMask(), colorModel.getBlueMask());
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[3];
            for (int y = 0; y < data.height; ++y) {
                for (int x = 0; x < data.width; ++x) {
                    raster.getPixel(x, y, pixelArray);
                    int pixel = palette.getPixel(new RGB(pixelArray[0], pixelArray[1], pixelArray[2]));
                    data.setPixel(x, y, pixel);
                }
            }
            return data;
        }
        if (bufferedImage.getColorModel() instanceof IndexColorModel) {
            IndexColorModel colorModel = (IndexColorModel)bufferedImage.getColorModel();
            int size = colorModel.getMapSize();
            byte[] reds = new byte[size];
            byte[] greens = new byte[size];
            byte[] blues = new byte[size];
            colorModel.getReds(reds);
            colorModel.getGreens(greens);
            colorModel.getBlues(blues);
            RGB[] rgbs = new RGB[size];
            for (int i = 0; i < rgbs.length; ++i) {
                rgbs[i] = new RGB(reds[i] & 0xFF, greens[i] & 0xFF, blues[i] & 0xFF);
            }
            PaletteData palette = new PaletteData(rgbs);
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            data.transparentPixel = colorModel.getTransparentPixel();
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[1];
            for (int y = 0; y < data.height; ++y) {
                for (int x = 0; x < data.width; ++x) {
                    raster.getPixel(x, y, pixelArray);
                    data.setPixel(x, y, pixelArray[0]);
                }
            }
            return data;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Rectangle, org.eclipse.swt.graphics.Image> createImageMap(Iterable<String> resourceNames, SortOrder areaSortOrder) {
        TreeMap<Rectangle, org.eclipse.swt.graphics.Image> map = new TreeMap<Rectangle, org.eclipse.swt.graphics.Image>(ImageUtils.getAreaComparator(areaSortOrder));
        for (String resourceName : resourceNames) {
            InputStream stream = null;
            try {
                stream = ImageUtils.class.getResourceAsStream(resourceName);
                for (ImageData data : new ImageLoader().load(stream)) {
                    org.eclipse.swt.graphics.Image image = new org.eclipse.swt.graphics.Image((Device)Display.getCurrent(), data);
                    map.put(image.getBounds(), image);
                }
            }
            finally {
                IOUtils.closeQuietly((Closeable)stream);
            }
        }
        return map;
    }

    public static Comparator<Rectangle> getAreaComparator(final SortOrder sortOrder) {
        return new Comparator<Rectangle>(){

            @Override
            public int compare(Rectangle r1, Rectangle r2) {
                int value = this.compareAscending(r1, r2);
                return SortOrder.DESCENDING.equals((Object)sortOrder) ? -value : value;
            }

            private int compareAscending(Rectangle r1, Rectangle r2) {
                int a1 = r1.width * r1.height;
                int a2 = r2.width * r2.height;
                if (a1 > a2) {
                    return 1;
                }
                if (a1 < a2) {
                    return -1;
                }
                return 0;
            }
        };
    }
}

