/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface;

import io.github.albertus82.util.logging.LoggerFactory;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JFaceMessages {
    private static final Logger log = LoggerFactory.getLogger(JFaceMessages.class);
    private static final String BASE_NAME = JFaceMessages.class.getName().toLowerCase(Locale.ROOT);
    private static ResourceBundle resources = ResourceBundle.getBundle(BASE_NAME, ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_PROPERTIES));

    private JFaceMessages() {
        throw new IllegalAccessError();
    }

    public static String getLanguage() {
        String language = resources.getLocale().getLanguage();
        if (!language.isEmpty()) {
            return language;
        }
        return Locale.ENGLISH.getLanguage();
    }

    public static void setResourceBundle(ResourceBundle bundle) {
        resources = bundle;
    }

    public static void setLanguage(String language) {
        if (language != null) {
            resources = ResourceBundle.getBundle(BASE_NAME, new Locale(language), ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_PROPERTIES));
        }
    }

    public static String get(String key) {
        String message;
        try {
            message = resources.getString(key);
            message = message != null ? message.replace("''", "'").trim() : "";
        }
        catch (MissingResourceException e) {
            log.log(Level.WARNING, "Cannot find message for key \"" + key + "\":", e);
            message = key;
        }
        return message;
    }

    public static String get(String key, Object ... params) {
        String message;
        ArrayList<String> stringParams = new ArrayList<String>(params.length);
        for (Object param : params) {
            stringParams.add(String.valueOf(param));
        }
        try {
            message = MessageFormat.format(resources.getString(key), stringParams.toArray());
            message = message != null ? message.trim() : "";
        }
        catch (MissingResourceException e) {
            log.log(Level.WARNING, "Cannot find message for key \"" + key + "\":", e);
            message = key;
        }
        return message;
    }

    public static Collection<String> getKeys() {
        if (resources != null) {
            return Collections.list(resources.getKeys());
        }
        return Collections.emptyList();
    }
}

