/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface;

import io.github.albertus82.util.logging.LoggerFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SwtUtils {
    public static final char KEY_OPEN = 'o';
    public static final char KEY_SAVE = 's';
    public static final char KEY_SELECT_ALL = 'a';
    public static final char KEY_CUT = 'x';
    public static final char KEY_COPY = 'c';
    public static final char KEY_PASTE = 'v';
    public static final char KEY_DELETE = '\u007f';
    public static final char KEY_UNDO = 'z';
    public static final char KEY_REDO = 'y';
    private static final String ORG_ECLIPSE_SWT_INTERNAL_GTK_VERSION = "org.eclipse.swt.internal.gtk.version";
    private static final String SWT_GTK3 = "SWT_GTK3";
    private static final Logger log = LoggerFactory.getLogger(SwtUtils.class);

    private SwtUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static String getMod1ShortcutLabel(char key) {
        if (SWT.MOD1 != 0x400000) {
            return "\tCtrl+" + Character.toUpperCase(key);
        }
        return "";
    }

    public static String getMod1ShortcutLabel(String key) {
        if (SWT.MOD1 != 0x400000) {
            return "\tCtrl+" + key;
        }
        return "";
    }

    public static String getShortcutLabel(String key) {
        if (SWT.MOD1 != 0x400000) {
            return "\t" + key;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkClipboard(Transfer transfer) {
        Display display = Display.getCurrent();
        if (display != null) {
            Clipboard clipboard = null;
            try {
                clipboard = new Clipboard(display);
                for (TransferData clipboardType : clipboard.getAvailableTypes()) {
                    if (!transfer.isSupportedType(clipboardType)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                if (clipboard != null) {
                    clipboard.dispose();
                }
            }
        }
        return false;
    }

    public static int convertHorizontalDLUsToPixels(Control control, int dlus) {
        return SwtUtils.convertDLUsToPixels(control, dlus, 256);
    }

    public static int convertVerticalDLUsToPixels(Control control, int dlus) {
        return SwtUtils.convertDLUsToPixels(control, dlus, 512);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int convertDLUsToPixels(Control control, int dlus, int orientation) {
        if (orientation != 256 && orientation != 512) {
            throw new IllegalArgumentException("orientation can be only SWT.HORIZONTAL or SWT.VERTICAL");
        }
        GC gc = null;
        try {
            gc = new GC((Drawable)control);
            gc.setFont(control.getFont());
            int n = orientation == 512 ? Dialog.convertVerticalDLUsToPixels((FontMetrics)gc.getFontMetrics(), (int)dlus) : Dialog.convertHorizontalDLUsToPixels((FontMetrics)gc.getFontMetrics(), (int)dlus);
            return n;
        }
        finally {
            if (gc != null) {
                gc.dispose();
            }
        }
    }

    @Nullable
    public static Boolean isGtk3() {
        try {
            return SwtUtils.isGtk3(Util.isGtk(), SWT.getVersion(), System.getProperty(ORG_ECLIPSE_SWT_INTERNAL_GTK_VERSION), System.getProperty(SWT_GTK3) != null ? System.getProperty(SWT_GTK3) : System.getenv(SWT_GTK3));
        }
        catch (SecurityException e) {
            log.log(Level.WARNING, "Cannot determine GTK version:", e);
            return null;
        }
    }

    static boolean isGtk3(boolean isGtk, int swtVersion, @Nullable String gtkVersion, @Nullable String swtGtk3) {
        if (!isGtk) {
            return false;
        }
        if (gtkVersion != null) {
            return gtkVersion.startsWith("3");
        }
        if (swtVersion < 4300) {
            return false;
        }
        if (swtVersion >= 4300 && swtVersion < 4400) {
            return swtGtk3 != null && "1".equals(swtGtk3);
        }
        return swtGtk3 == null || !"0".equals(swtGtk3);
    }

    public static void blockShell(@Nullable Shell shell) {
        if (shell != null && !shell.isDisposed()) {
            shell.setCursor(shell.getDisplay().getSystemCursor(1));
            shell.setEnabled(false);
        }
    }

    public static void unblockShell(@Nullable Shell shell) {
        if (shell != null && !shell.isDisposed()) {
            shell.setEnabled(true);
            shell.setCursor(null);
        }
    }
}

