/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.cocoa;

import io.github.albertus82.jface.JFaceMessages;
import io.github.albertus82.jface.cocoa.CocoaEnhancerException;
import io.github.albertus82.util.logging.LoggerFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;

public class CocoaUIEnhancer {
    private static final Logger log = LoggerFactory.getLogger(CocoaUIEnhancer.class);
    private static final String ITEM_AT_INDEX = "itemAtIndex";
    private static final int kAboutMenuItem = 0;
    private static final int kPreferencesMenuItem = 2;
    private final Display display;
    private Callback proc3Args;
    private long sel_aboutMenuItemSelected_;
    private long sel_preferencesMenuItemSelected_;
    private long sel_toolbarButtonClicked_;

    public CocoaUIEnhancer(Display display) {
        this.display = display;
    }

    public void hookApplicationMenu(@Nullable Listener quitListener, @Nullable Listener aboutListener, @Nullable Listener preferencesListener) throws CocoaEnhancerException {
        try {
            this.hookApplicationMenu(quitListener, new ListenerCallbackObject(aboutListener, preferencesListener));
        }
        catch (Exception e) {
            throw new CocoaEnhancerException(e);
        }
        catch (LinkageError le) {
            throw new CocoaEnhancerException(le);
        }
    }

    public void hookApplicationMenu(@Nullable Listener quitListener, @Nullable IAction aboutAction, @Nullable IAction preferencesAction) throws CocoaEnhancerException {
        try {
            this.hookApplicationMenu(quitListener, new ActionCallbackObject(aboutAction, preferencesAction));
        }
        catch (Exception e) {
            throw new CocoaEnhancerException(e);
        }
        catch (LinkageError le) {
            throw new CocoaEnhancerException(le);
        }
    }

    private void hookApplicationMenu(@Nullable Listener quitListener, CallbackObject callbackObject) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        if (!Util.isCocoa()) {
            log.log(Level.WARNING, JFaceMessages.get("err.cocoa.enhancer.platform"));
        }
        this.initialize(callbackObject);
        if (!this.display.isDisposed() && quitListener != null) {
            this.display.addListener(21, quitListener);
        }
        this.display.disposeExec(new Runnable(){

            @Override
            public void run() {
                CocoaUIEnhancer.this.proc3Args.dispose();
            }
        });
    }

    private void initialize(CallbackObject callbackObject) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Class<?> osCls = Class.forName("org.eclipse.swt.internal.cocoa.OS");
        if (this.sel_toolbarButtonClicked_ == 0L) {
            this.sel_preferencesMenuItemSelected_ = CocoaUIEnhancer.registerName(osCls, "preferencesMenuItemSelected:");
            this.sel_aboutMenuItemSelected_ = CocoaUIEnhancer.registerName(osCls, "aboutMenuItemSelected:");
        }
        this.proc3Args = new Callback((Object)callbackObject, "actionProc", 3);
        long proc3 = this.proc3Args.getAddress();
        if (proc3 == 0L) {
            SWT.error((int)3);
        }
        Object object = CocoaUIEnhancer.invoke(osCls, "objc_lookUpClass", new Object[]{"SWTApplicationDelegate"});
        long cls = CocoaUIEnhancer.convertToLong(object);
        CocoaUIEnhancer.invoke(osCls, "class_addMethod", new Object[]{CocoaUIEnhancer.wrapPointer(cls), CocoaUIEnhancer.wrapPointer(this.sel_preferencesMenuItemSelected_), CocoaUIEnhancer.wrapPointer(proc3), "@:@"});
        CocoaUIEnhancer.invoke(osCls, "class_addMethod", new Object[]{CocoaUIEnhancer.wrapPointer(cls), CocoaUIEnhancer.wrapPointer(this.sel_aboutMenuItemSelected_), CocoaUIEnhancer.wrapPointer(proc3), "@:@"});
        Class<?> nsapplicationCls = Class.forName("org.eclipse.swt.internal.cocoa.NSApplication");
        Class<?> nsmenuCls = Class.forName("org.eclipse.swt.internal.cocoa.NSMenu");
        Object sharedApplication = CocoaUIEnhancer.invoke(nsapplicationCls, "sharedApplication");
        Object mainMenu = CocoaUIEnhancer.invoke(sharedApplication, "mainMenu");
        Object mainMenuItem = CocoaUIEnhancer.invoke(nsmenuCls, mainMenu, ITEM_AT_INDEX, (Object[])new Number[]{CocoaUIEnhancer.wrapPointer(0L)});
        Object appMenu = CocoaUIEnhancer.invoke(mainMenuItem, "submenu");
        Object aboutMenuItem = CocoaUIEnhancer.invoke(nsmenuCls, appMenu, ITEM_AT_INDEX, (Object[])new Number[]{CocoaUIEnhancer.wrapPointer(0L)});
        Object prefMenuItem = CocoaUIEnhancer.invoke(nsmenuCls, appMenu, ITEM_AT_INDEX, (Object[])new Number[]{CocoaUIEnhancer.wrapPointer(2L)});
        Class<?> nsmenuitemCls = Class.forName("org.eclipse.swt.internal.cocoa.NSMenuItem");
        if (callbackObject.aboutEnabled) {
            CocoaUIEnhancer.invoke(nsmenuitemCls, aboutMenuItem, "setAction", (Object[])new Number[]{CocoaUIEnhancer.wrapPointer(this.sel_aboutMenuItemSelected_)});
        }
        CocoaUIEnhancer.invoke(nsmenuitemCls, aboutMenuItem, "setEnabled", (Object[])new Boolean[]{callbackObject.aboutEnabled});
        if (callbackObject.preferencesEnabled) {
            CocoaUIEnhancer.invoke(nsmenuitemCls, prefMenuItem, "setAction", (Object[])new Number[]{CocoaUIEnhancer.wrapPointer(this.sel_preferencesMenuItemSelected_)});
        }
        CocoaUIEnhancer.invoke(nsmenuitemCls, prefMenuItem, "setEnabled", (Object[])new Boolean[]{callbackObject.preferencesEnabled});
    }

    private static Object invoke(Class<?> clazz, Object target, String methodName, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class[] signature = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            Class<?> thisClass = args[i].getClass();
            signature[i] = thisClass == Integer.class ? Integer.TYPE : (thisClass == Long.class ? Long.TYPE : (thisClass == Byte.class ? Byte.TYPE : (thisClass == Boolean.class ? Boolean.TYPE : thisClass)));
        }
        Method method = clazz.getMethod(methodName, signature);
        return method.invoke(target, args);
    }

    private static Object invoke(Class<?> clazz, String methodName, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return CocoaUIEnhancer.invoke(clazz, null, methodName, args);
    }

    private static Object invoke(Class<?> cls, String methodName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return CocoaUIEnhancer.invoke(cls, methodName, (Class[])null, (Object[])null);
    }

    private static Object invoke(Class<?> cls, String methodName, Class<?>[] paramTypes, Object ... arguments) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = cls.getDeclaredMethod(methodName, paramTypes);
        return method.invoke(null, arguments);
    }

    private static Object invoke(Object obj, String methodName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return CocoaUIEnhancer.invoke(obj, methodName, (Class[])null, (Object[])null);
    }

    private static Object invoke(Object obj, String methodName, Class<?>[] paramTypes, Object ... arguments) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = obj.getClass().getDeclaredMethod(methodName, paramTypes);
        return method.invoke(obj, arguments);
    }

    private static long convertToLong(Object object) {
        if (object instanceof Integer) {
            Integer i = (Integer)object;
            return i.longValue();
        }
        if (object instanceof Long) {
            Long l = (Long)object;
            return l;
        }
        return 0L;
    }

    private static Number wrapPointer(long value) {
        Class<Number> ptrClass;
        Class<Number> clazz = ptrClass = C.PTR_SIZEOF == 8 ? Long.TYPE : Integer.TYPE;
        if (ptrClass == Long.TYPE) {
            return value;
        }
        return (int)value;
    }

    private static long registerName(Class<?> osCls, String name) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object object = CocoaUIEnhancer.invoke(osCls, "sel_registerName", new Object[]{name});
        return CocoaUIEnhancer.convertToLong(object);
    }

    private class ListenerCallbackObject
    extends CallbackObject {
        private final Listener aboutListener;
        private final Listener preferencesListener;

        private ListenerCallbackObject(@Nullable Listener aboutListener, Listener preferencesListener) {
            super(aboutListener != null, preferencesListener != null);
            this.aboutListener = aboutListener;
            this.preferencesListener = preferencesListener;
        }

        @Override
        long actionProc(long id, long sel, long arg0) {
            if (sel == CocoaUIEnhancer.this.sel_aboutMenuItemSelected_ && this.aboutListener != null) {
                this.aboutListener.handleEvent(null);
            } else if (sel == CocoaUIEnhancer.this.sel_preferencesMenuItemSelected_ && this.preferencesListener != null) {
                this.preferencesListener.handleEvent(null);
            }
            return 99L;
        }
    }

    private abstract class CallbackObject {
        static final long RETURN_VALUE = 99L;
        private final boolean aboutEnabled;
        private final boolean preferencesEnabled;

        protected CallbackObject(boolean aboutEnabled, boolean preferencesEnabled) {
            this.aboutEnabled = aboutEnabled;
            this.preferencesEnabled = preferencesEnabled;
        }

        int actionProc(int id, int sel, int arg0) {
            return (int)this.actionProc((long)id, (long)sel, (long)arg0);
        }

        abstract long actionProc(long var1, long var3, long var5);
    }

    private class ActionCallbackObject
    extends CallbackObject {
        private final IAction preferencesAction;
        private final IAction aboutAction;

        private ActionCallbackObject(@Nullable IAction aboutAction, IAction preferencesAction) {
            super(aboutAction != null, preferencesAction != null);
            this.aboutAction = aboutAction;
            this.preferencesAction = preferencesAction;
        }

        @Override
        long actionProc(long id, long sel, long arg0) {
            if (sel == CocoaUIEnhancer.this.sel_aboutMenuItemSelected_ && this.aboutAction != null) {
                this.aboutAction.run();
            } else if (sel == CocoaUIEnhancer.this.sel_preferencesMenuItemSelected_ && this.preferencesAction != null) {
                this.preferencesAction.run();
            }
            return 99L;
        }
    }
}

