/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.console;

import io.github.albertus82.jface.JFaceMessages;
import io.github.albertus82.jface.SwtUtils;
import io.github.albertus82.jface.console.ScrollableConsole;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class ListConsole
extends ScrollableConsole<List> {
    public static final int DEFAULT_LIMIT = 10000;
    private final StringBuilder charBuffer = new StringBuilder();
    private Menu contextMenu;
    private MenuItem copyMenuItem;
    private MenuItem selectAllMenuItem;
    private MenuItem clearMenuItem;

    protected ListConsole(Composite parent, Object layoutData, boolean redirectSystemStream) {
        super(parent, layoutData, redirectSystemStream);
    }

    @Override
    protected List createScrollable(Composite parent) {
        List list = new List(parent, 2818);
        this.configureStyledText(list);
        return list;
    }

    protected void configureStyledText(List list) {
        this.createContextMenu(list);
    }

    protected void createContextMenu(final List list) {
        this.contextMenu = new Menu((Control)list);
        this.copyMenuItem = this.createCopyMenuItem(list);
        new MenuItem(this.contextMenu, 2);
        this.selectAllMenuItem = this.createSelectAllMenuItem(list);
        new MenuItem(this.contextMenu, 2);
        this.clearMenuItem = this.createClearMenuItem();
        list.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent mde) {
                boolean notEmpty = !ListConsole.this.isEmpty();
                ListConsole.this.selectAllMenuItem.setEnabled(notEmpty);
                ListConsole.this.clearMenuItem.setEnabled(notEmpty);
                ListConsole.this.copyMenuItem.setEnabled(list.getSelectionCount() > 0);
                ListConsole.this.contextMenu.setVisible(true);
            }
        });
        list.setMenu(this.contextMenu);
    }

    protected MenuItem createClearMenuItem() {
        MenuItem clear = new MenuItem(this.contextMenu, 8);
        clear.setText(JFaceMessages.get("lbl.menu.item.clear"));
        clear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                ListConsole.this.clear();
            }
        });
        return clear;
    }

    protected MenuItem createSelectAllMenuItem(final List list) {
        MenuItem selectAll = new MenuItem(this.contextMenu, 8);
        selectAll.setText(JFaceMessages.get("lbl.menu.item.select.all") + SwtUtils.getMod1ShortcutLabel('a'));
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                list.selectAll();
            }
        });
        list.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent ke) {
                if (ke.stateMask == SWT.MOD1 && ke.keyCode == 97) {
                    ke.doit = false;
                    list.selectAll();
                }
            }
        });
        return selectAll;
    }

    protected MenuItem createCopyMenuItem(final List list) {
        MenuItem copy = new MenuItem(this.contextMenu, 8);
        copy.setText(JFaceMessages.get("lbl.menu.item.copy") + SwtUtils.getMod1ShortcutLabel('c'));
        copy.setAccelerator(SWT.MOD1 | 0x63);
        copy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                ListConsole.this.copy(list);
            }
        });
        list.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.stateMask == SWT.MOD1 && e.keyCode == 99) {
                    e.doit = false;
                    ListConsole.this.copy(list);
                }
            }
        });
        return copy;
    }

    @Override
    public void clear() {
        ((List)this.scrollable).removeAll();
    }

    @Override
    public boolean isEmpty() {
        return ((List)this.scrollable).getItemCount() == 0;
    }

    @Override
    public boolean hasSelection() {
        return ((List)this.scrollable).getSelectionCount() > 0;
    }

    public int getLastItemIndex() {
        return ((List)this.scrollable).getItemCount() - 1;
    }

    @Override
    protected int getDefaultLimit() {
        return 10000;
    }

    @Override
    protected void doPrint(String value, int maxItems) {
        ((List)this.scrollable).setRedraw(false);
        int overflow = this.getLastItemIndex() - maxItems;
        if (overflow > 0) {
            int[] indices = new int[overflow];
            for (int i = 0; i < overflow; ++i) {
                indices[i] = i;
            }
            ((List)this.scrollable).remove(indices);
        }
        this.charBuffer.setLength(0);
        if (this.isEmpty()) {
            ((List)this.scrollable).add("");
        } else {
            this.charBuffer.append(((List)this.scrollable).getItem(this.getLastItemIndex()));
        }
        for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) == '\r' && value.length() > i + 1 && value.charAt(i + 1) == '\n') {
                this.newLine();
                ++i;
                continue;
            }
            if (value.charAt(i) == '\r' || value.charAt(i) == '\n') {
                this.newLine();
                continue;
            }
            this.charBuffer.append(value.charAt(i));
        }
        ((List)this.scrollable).setItem(this.getLastItemIndex(), this.charBuffer.toString());
        ((List)this.scrollable).setTopIndex(this.getLastItemIndex());
        ((List)this.scrollable).setRedraw(true);
    }

    private void newLine() {
        ((List)this.scrollable).setItem(Math.max(this.getLastItemIndex(), 0), this.charBuffer.toString());
        this.charBuffer.setLength(0);
        ((List)this.scrollable).add("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(List list) {
        if (list.getSelectionIndex() != -1) {
            StringBuilder text = new StringBuilder();
            for (int i = 0; i < list.getSelectionCount(); ++i) {
                text.append(list.getSelection()[i]);
                if (i == list.getSelectionCount() - 1) continue;
                text.append(newLine);
            }
            Clipboard clipboard = null;
            try {
                clipboard = new Clipboard(list.getDisplay());
                clipboard.setContents((Object[])new String[]{text.toString()}, (Transfer[])new TextTransfer[]{TextTransfer.getInstance()});
            }
            finally {
                if (clipboard != null) {
                    clipboard.dispose();
                }
            }
        }
    }

    protected Menu getContextMenu() {
        return this.contextMenu;
    }

    protected void setContextMenu(Menu contextMenu) {
        this.contextMenu = contextMenu;
    }

    protected MenuItem getCopyMenuItem() {
        return this.copyMenuItem;
    }

    protected void setCopyMenuItem(MenuItem copyMenuItem) {
        this.copyMenuItem = copyMenuItem;
    }

    protected MenuItem getSelectAllMenuItem() {
        return this.selectAllMenuItem;
    }

    protected void setSelectAllMenuItem(MenuItem selectAllMenuItem) {
        this.selectAllMenuItem = selectAllMenuItem;
    }

    protected MenuItem getClearMenuItem() {
        return this.clearMenuItem;
    }

    protected void setClearMenuItem(MenuItem clearMenuItem) {
        this.clearMenuItem = clearMenuItem;
    }
}

