/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.console;

import io.github.albertus82.jface.DisplayThreadExecutor;
import io.github.albertus82.jface.JFaceMessages;
import io.github.albertus82.util.ISupplier;
import io.github.albertus82.util.NewLine;
import io.github.albertus82.util.Supplier;
import io.github.albertus82.util.logging.LoggerFactory;
import io.github.albertus82.util.logging.LoggingSupport;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Widget;

public abstract class ScrollableConsole<T extends Scrollable>
extends OutputStream {
    private static final Logger log = LoggerFactory.getLogger(ScrollableConsole.class);
    protected static final PrintStream defaultSysOut = System.out;
    protected static final PrintStream defaultSysErr = System.err;
    protected static final String newLine = NewLine.SYSTEM_LINE_SEPARATOR;
    protected final boolean redirectSystemStream;
    protected final T scrollable;
    protected ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
    private ISupplier<Integer> limit;

    protected ScrollableConsole(Composite parent, Object layoutData, boolean redirectSystemStream) {
        this.redirectSystemStream = redirectSystemStream;
        this.scrollable = this.createScrollable(parent);
        this.scrollable.setLayoutData(layoutData);
        this.scrollable.setFont(JFaceResources.getTextFont());
        if (redirectSystemStream) {
            this.scrollable.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent de) {
                    ScrollableConsole.this.resetStreams();
                }
            });
            this.redirectStreams();
        }
    }

    protected abstract T createScrollable(Composite var1);

    protected abstract void doPrint(String var1, int var2);

    public abstract void clear();

    public abstract boolean isEmpty();

    public abstract boolean hasSelection();

    @Override
    public void write(int b) throws IOException {
        this.ensureOpen();
        this.byteBuffer.write(b);
    }

    @Override
    public void flush() throws IOException {
        this.ensureOpen();
        if (this.byteBuffer.size() != 0) {
            this.print(this.byteBuffer.toString());
            this.byteBuffer.reset();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.byteBuffer != null) {
            this.flush();
            if (this.redirectSystemStream) {
                this.resetStreams();
            }
            this.byteBuffer = null;
        }
    }

    protected void print(String value) {
        final String toPrint = value == null ? String.valueOf(value) : value;
        final int capacity = this.getLimit();
        new DisplayThreadExecutor((Widget)this.scrollable, DisplayThreadExecutor.Mode.ASYNC){

            @Override
            protected void onError(Exception exception) {
                ScrollableConsole.this.failSafePrint(toPrint);
            }
        }.execute(new Runnable(){

            @Override
            public void run() {
                ScrollableConsole.this.doPrint(toPrint, capacity);
            }
        });
    }

    protected void failSafePrint(String value) {
        defaultSysOut.print(value);
    }

    protected void redirectStreams() {
        PrintStream ps = new PrintStream(this, true);
        try {
            System.setOut(ps);
            System.setErr(ps);
            this.redirectLogging();
        }
        catch (RuntimeException re) {
            log.log(Level.SEVERE, JFaceMessages.get("err.console.streams.redirect"), re);
        }
    }

    protected void redirectLogging() {
        Logger rootLogger = LoggingSupport.getRootLogger();
        for (int i = 0; i < rootLogger.getHandlers().length; ++i) {
            Handler oldHandler = rootLogger.getHandlers()[i];
            if (!(oldHandler instanceof ConsoleHandler)) continue;
            ConsoleHandler newConsoleHandler = new ConsoleHandler();
            newConsoleHandler.setLevel(oldHandler.getLevel());
            newConsoleHandler.setFilter(oldHandler.getFilter());
            if (oldHandler.getFormatter() != null) {
                newConsoleHandler.setFormatter(oldHandler.getFormatter());
            }
            if (oldHandler.getErrorManager() != null) {
                newConsoleHandler.setErrorManager(oldHandler.getErrorManager());
            }
            try {
                newConsoleHandler.setEncoding(oldHandler.getEncoding());
            }
            catch (UnsupportedEncodingException uee) {
                throw new IllegalStateException(uee);
            }
            rootLogger.removeHandler(oldHandler);
            rootLogger.addHandler(newConsoleHandler);
        }
    }

    protected void resetStreams() {
        try {
            System.setOut(defaultSysOut);
            System.setErr(defaultSysErr);
        }
        catch (RuntimeException re) {
            log.log(Level.SEVERE, JFaceMessages.get("err.console.streams.reset"), re);
        }
    }

    private void ensureOpen() throws IOException {
        if (this.byteBuffer == null) {
            throw new IOException("Stream closed");
        }
    }

    protected abstract int getDefaultLimit();

    public int getLimit() {
        try {
            return this.limit != null && this.limit.get() != null ? this.limit.get().intValue() : this.getDefaultLimit();
        }
        catch (RuntimeException re) {
            log.log(Level.WARNING, JFaceMessages.get("err.console.capacity") + ' ' + JFaceMessages.get("err.configuration.using.default", this.getDefaultLimit()), re);
            return this.getDefaultLimit();
        }
    }

    public void setLimit(ISupplier<Integer> limit) {
        this.limit = limit;
    }

    public void setLimit(final int limit) {
        this.limit = new Supplier<Integer>(){

            @Override
            public Integer get() {
                return limit;
            }
        };
    }

    public Font getFont() {
        return this.scrollable.getFont();
    }

    public void setFont(Font font) {
        this.scrollable.setFont(font);
    }

    public void setFont(FontData[] fds) {
        if (!Arrays.equals(fds, this.getFont().getFontData())) {
            final Font font = new Font((Device)this.scrollable.getDisplay(), fds);
            this.scrollable.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    font.dispose();
                }
            });
            this.setFont(font);
        }
    }

    public T getScrollable() {
        return this.scrollable;
    }
}

