/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.console;

import io.github.albertus82.jface.JFaceMessages;
import io.github.albertus82.jface.SwtUtils;
import io.github.albertus82.jface.console.ScrollableConsole;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class StyledTextConsole
extends ScrollableConsole<StyledText> {
    public static final int DEFAULT_LIMIT = 100000;
    protected static final int MARGIN = 4;
    private final StringBuilder charBuffer = new StringBuilder();
    private Menu contextMenu;
    private MenuItem copyMenuItem;
    private MenuItem selectAllMenuItem;
    private MenuItem clearMenuItem;

    public StyledTextConsole(Composite parent, Object layoutData, boolean redirectSystemStreams) {
        super(parent, layoutData, redirectSystemStreams);
    }

    @Override
    protected StyledText createScrollable(Composite parent) {
        StyledText styledText = new StyledText(parent, 2824);
        this.configureStyledText(styledText);
        return styledText;
    }

    protected void configureStyledText(StyledText styledText) {
        styledText.setMargins(4, 4, 4, 4);
        this.createContextMenu(styledText);
    }

    protected void createContextMenu(final StyledText styledText) {
        this.contextMenu = new Menu((Control)styledText);
        this.copyMenuItem = this.createCopyMenuItem(styledText);
        new MenuItem(this.contextMenu, 2);
        this.selectAllMenuItem = this.createSelectAllMenuItem(styledText);
        new MenuItem(this.contextMenu, 2);
        this.clearMenuItem = this.createClearMenuItem();
        styledText.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent mde) {
                boolean notEmpty = !StyledTextConsole.this.isEmpty();
                StyledTextConsole.this.selectAllMenuItem.setEnabled(notEmpty);
                StyledTextConsole.this.clearMenuItem.setEnabled(notEmpty);
                StyledTextConsole.this.copyMenuItem.setEnabled(styledText.getSelectionCount() > 0);
            }
        });
        styledText.setMenu(this.contextMenu);
    }

    protected MenuItem createClearMenuItem() {
        MenuItem clear = new MenuItem(this.contextMenu, 8);
        clear.setText(JFaceMessages.get("lbl.menu.item.clear"));
        clear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                StyledTextConsole.this.clear();
            }
        });
        return clear;
    }

    protected MenuItem createSelectAllMenuItem(final StyledText styledText) {
        MenuItem selectAll = new MenuItem(this.contextMenu, 8);
        selectAll.setText(JFaceMessages.get("lbl.menu.item.select.all") + SwtUtils.getMod1ShortcutLabel('a'));
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                styledText.invokeAction(262209);
            }
        });
        styledText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent ke) {
                if (ke.stateMask == SWT.MOD1 && ke.keyCode == 97) {
                    styledText.invokeAction(262209);
                }
            }
        });
        return selectAll;
    }

    protected MenuItem createCopyMenuItem(final StyledText styledText) {
        MenuItem copy = new MenuItem(this.contextMenu, 8);
        copy.setText(JFaceMessages.get("lbl.menu.item.copy") + SwtUtils.getMod1ShortcutLabel('c'));
        copy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                styledText.invokeAction(17039369);
            }
        });
        return copy;
    }

    @Override
    public void clear() {
        ((StyledText)this.scrollable).setText("");
    }

    @Override
    public boolean isEmpty() {
        return this.scrollable == null || ((StyledText)this.scrollable).isDisposed() || ((StyledText)this.scrollable).getCharCount() == 0;
    }

    @Override
    public boolean hasSelection() {
        return this.scrollable != null && !((StyledText)this.scrollable).isDisposed() && ((StyledText)this.scrollable).getSelectionCount() > 0;
    }

    @Override
    protected int getDefaultLimit() {
        return 100000;
    }

    @Override
    protected void doPrint(String value, int maxChars) {
        this.charBuffer.setLength(0);
        this.charBuffer.append(((StyledText)this.scrollable).getText());
        int replaceLength = 0;
        while (this.charBuffer.length() + value.length() > maxChars) {
            int indexOfNewLine = this.charBuffer.indexOf(newLine);
            if (indexOfNewLine != -1) {
                int replaceEnd = indexOfNewLine + newLine.length();
                replaceLength += replaceEnd;
                this.charBuffer.replace(0, replaceEnd, "");
                continue;
            }
            replaceLength = -1;
            break;
        }
        if (replaceLength >= 0) {
            if (replaceLength != 0) {
                ((StyledText)this.scrollable).replaceTextRange(0, replaceLength, "");
            }
            ((StyledText)this.scrollable).append(value);
        } else {
            ((StyledText)this.scrollable).setText(value);
        }
        ((StyledText)this.scrollable).setTopPixel((((StyledText)this.scrollable).getLineCount() - 1) * ((StyledText)this.scrollable).getLineHeight());
    }

    protected Menu getContextMenu() {
        return this.contextMenu;
    }

    protected void setContextMenu(Menu contextMenu) {
        this.contextMenu = contextMenu;
    }

    protected MenuItem getCopyMenuItem() {
        return this.copyMenuItem;
    }

    protected void setCopyMenuItem(MenuItem copyMenuItem) {
        this.copyMenuItem = copyMenuItem;
    }

    protected MenuItem getSelectAllMenuItem() {
        return this.selectAllMenuItem;
    }

    protected void setSelectAllMenuItem(MenuItem selectAllMenuItem) {
        this.selectAllMenuItem = selectAllMenuItem;
    }

    protected MenuItem getClearMenuItem() {
        return this.clearMenuItem;
    }

    protected void setClearMenuItem(MenuItem clearMenuItem) {
        this.clearMenuItem = clearMenuItem;
    }
}

