/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.console;

import io.github.albertus82.jface.console.ScrollableConsole;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class TextConsole
extends ScrollableConsole<Text> {
    public static final int DEFAULT_LIMIT = 100000;

    public TextConsole(Composite parent, Object layoutData, boolean redirectSystemStreams) {
        super(parent, layoutData, redirectSystemStreams);
    }

    @Override
    protected Text createScrollable(Composite parent) {
        Text text = new Text(parent, 2824);
        if (Util.isWindows()) {
            text.setBackground(text.getDisplay().getSystemColor(25));
        }
        return text;
    }

    @Override
    public void clear() {
        ((Text)this.scrollable).setText("");
    }

    @Override
    public boolean isEmpty() {
        return this.scrollable == null || ((Text)this.scrollable).isDisposed() || ((Text)this.scrollable).getCharCount() == 0;
    }

    @Override
    public boolean hasSelection() {
        return this.scrollable != null && !((Text)this.scrollable).isDisposed() && ((Text)this.scrollable).getSelectionCount() > 0;
    }

    @Override
    protected int getDefaultLimit() {
        return 100000;
    }

    @Override
    protected void doPrint(String value, int maxChars) {
        if (((Text)this.scrollable).getCharCount() < maxChars) {
            ((Text)this.scrollable).append(value);
        } else {
            ((Text)this.scrollable).setText(value.startsWith(newLine) ? value.substring(newLine.length()) : value);
        }
        ((Text)this.scrollable).setTopIndex(((Text)this.scrollable).getLineCount() - 1);
    }
}

