/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.decoration;

import io.github.albertus82.jface.listener.DecorationModifyListener;
import io.github.albertus82.jface.validation.ControlValidator;
import io.github.albertus82.util.ISupplier;
import io.github.albertus82.util.Localized;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;

public class ControlValidatorDecoration {
    public static final int DEFAULT_STYLE = 16512;
    public static final String DEFAULT_TYPE = "DEC_ERROR";
    protected final ControlValidator<?> validator;
    protected final ISupplier<String> message;
    protected final int style;
    protected final String type;

    public ControlValidatorDecoration(ControlValidator<?> validator, ISupplier<String> message, int style, String type) {
        this.validator = validator;
        this.message = message;
        this.style = style;
        this.type = type;
        Object control = validator.getControl();
        ControlDecoration controlDecorator = new ControlDecoration(control, style);
        controlDecorator.hide();
        Image image = FieldDecorationRegistry.getDefault().getFieldDecoration(type).getImage();
        controlDecorator.setImage(image);
        this.adjustLayoutData((Control)control, image);
        control.addListener(24, (Listener)new DecorationModifyListener(controlDecorator, validator, message));
    }

    public ControlValidatorDecoration(ControlValidator<?> validator, ISupplier<String> message) {
        this(validator, message, 16512, DEFAULT_TYPE);
    }

    public ControlValidatorDecoration(ControlValidator<?> validator, final String message) {
        this(validator, new Localized(){

            @Override
            public String getString() {
                return message;
            }
        });
    }

    protected void adjustLayoutData(Control control, Image image) {
    }
}

