/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.i18n;

import io.github.albertus82.util.ISupplier;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.widgets.Widget;

public class LocalizedWidgets
implements Map<Widget, ISupplier<String>> {
    private static final Map<Class<? extends Widget>, Method> setTextMethods = new HashMap<Class<? extends Widget>, Method>();
    private final Map<Widget, ISupplier<String>> wrappedMap;

    public LocalizedWidgets() {
        this.wrappedMap = new HashMap<Widget, ISupplier<String>>();
    }

    public LocalizedWidgets(int initialCapacity) {
        this.wrappedMap = new HashMap<Widget, ISupplier<String>>(initialCapacity);
    }

    @Override
    public ISupplier<String> put(Widget widget, ISupplier<String> textSupplier) {
        Class<?> widgetClass = widget.getClass();
        if (!setTextMethods.containsKey(widgetClass)) {
            try {
                setTextMethods.put(widgetClass, widgetClass.getMethod("setText", String.class));
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException(String.valueOf(widget), e);
            }
        }
        LocalizedWidgets.setText(widget, textSupplier);
        return this.wrappedMap.put(widget, textSupplier);
    }

    @Override
    public void putAll(Map<? extends Widget, ? extends ISupplier<String>> m) {
        for (Map.Entry<? extends Widget, ? extends ISupplier<String>> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public int size() {
        return this.wrappedMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrappedMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object widget) {
        return this.wrappedMap.containsKey(widget);
    }

    @Override
    public boolean containsValue(Object textSupplier) {
        return this.wrappedMap.containsValue(textSupplier);
    }

    @Override
    public ISupplier<String> get(Object widget) {
        return this.wrappedMap.get(widget);
    }

    @Override
    public ISupplier<String> remove(Object widget) {
        return this.wrappedMap.remove(widget);
    }

    @Override
    public void clear() {
        this.wrappedMap.clear();
    }

    @Override
    public Set<Widget> keySet() {
        return this.wrappedMap.keySet();
    }

    @Override
    public Collection<ISupplier<String>> values() {
        return this.wrappedMap.values();
    }

    @Override
    public Set<Map.Entry<Widget, ISupplier<String>>> entrySet() {
        return this.wrappedMap.entrySet();
    }

    public <T extends Widget> Map.Entry<T, ISupplier<String>> putAndReturn(T widget, ISupplier<String> textSupplier) {
        this.put(widget, textSupplier);
        return new AbstractMap.SimpleEntry<T, ISupplier<String>>(widget, textSupplier);
    }

    public void resetText(Widget widget) {
        LocalizedWidgets.setText(widget, this.wrappedMap.get(widget));
    }

    public void resetAllTexts() {
        for (Map.Entry<Widget, ISupplier<String>> entry : this.wrappedMap.entrySet()) {
            LocalizedWidgets.setText(entry.getKey(), entry.getValue());
        }
    }

    private static void setText(Widget widget, ISupplier<String> textSupplier) {
        if (textSupplier != null && widget != null && !widget.isDisposed()) {
            try {
                setTextMethods.get(widget.getClass()).invoke((Object)widget, String.valueOf(textSupplier.get()));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

