/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.listener;

import io.github.albertus82.jface.listener.AbstractNumberVerifyListener;
import io.github.albertus82.util.ISupplier;
import io.github.albertus82.util.logging.LoggerFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

abstract class AbstractIntegerVerifyListener<T extends Number>
extends AbstractNumberVerifyListener<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractIntegerVerifyListener.class);

    protected AbstractIntegerVerifyListener(boolean allowNegatives) {
        super(allowNegatives);
    }

    protected AbstractIntegerVerifyListener(ISupplier<Boolean> allowNegatives) {
        super(allowNegatives);
    }

    @Override
    protected boolean isNumeric(@Nullable String string) {
        block3: {
            if (string != null) {
                try {
                    this.parseNumber(string);
                    return true;
                }
                catch (NumberFormatException e) {
                    log.log(Level.FINEST, "The value provided is not a valid representation of a number:", e);
                    if (!Boolean.TRUE.equals(this.allowNegatives.get()) || !"-".equals(string)) break block3;
                    return true;
                }
            }
        }
        return false;
    }
}

