/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.maps;

import java.io.Serializable;

public class MapBounds
implements Serializable {
    private static final long serialVersionUID = -3330484387877221810L;
    public static final int LATITUDE_MIN_VALUE = -90;
    public static final int LATITUDE_MAX_VALUE = 90;
    public static final int LONGITUDE_MIN_VALUE = -180;
    public static final int LONGITUDE_MAX_VALUE = 180;
    private final Double northEastLat;
    private final Double southWestLat;
    private final Double northEastLng;
    private final Double southWestLng;

    public MapBounds() {
        this(null, null, null, null);
    }

    public MapBounds(Double northEastLat, Double southWestLat, Double northEastLng, Double southWestLng) {
        this.northEastLat = northEastLat;
        this.southWestLat = southWestLat;
        this.northEastLng = northEastLng;
        this.southWestLng = southWestLng;
    }

    public Double getNorthEastLat() {
        return this.northEastLat;
    }

    public Double getSouthWestLat() {
        return this.southWestLat;
    }

    public Double getNorthEastLng() {
        return this.northEastLng;
    }

    public Double getSouthWestLng() {
        return this.southWestLng;
    }

    public String toString() {
        return "MapBounds [northEastLat=" + this.northEastLat + ", southWestLat=" + this.southWestLat + ", northEastLng=" + this.northEastLng + ", southWestLng=" + this.southWestLng + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.northEastLat == null ? 0 : this.northEastLat.hashCode());
        result = 31 * result + (this.northEastLng == null ? 0 : this.northEastLng.hashCode());
        result = 31 * result + (this.southWestLat == null ? 0 : this.southWestLat.hashCode());
        result = 31 * result + (this.southWestLng == null ? 0 : this.southWestLng.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MapBounds)) {
            return false;
        }
        MapBounds other = (MapBounds)obj;
        if (this.northEastLat == null ? other.northEastLat != null : !this.northEastLat.equals(other.northEastLat)) {
            return false;
        }
        if (this.northEastLng == null ? other.northEastLng != null : !this.northEastLng.equals(other.northEastLng)) {
            return false;
        }
        if (this.southWestLat == null ? other.southWestLat != null : !this.southWestLat.equals(other.southWestLat)) {
            return false;
        }
        return !(this.southWestLng == null ? other.southWestLng != null : !this.southWestLng.equals(other.southWestLng));
    }

    public static MapBounds normalize(MapBounds bounds) {
        Double southWestLat = null;
        Double northEastLat = null;
        Double southWestLng = null;
        Double northEastLng = null;
        if (bounds.getSouthWestLat() != null && bounds.getNorthEastLat() != null) {
            southWestLat = Math.max(-90.0, bounds.getSouthWestLat());
            northEastLat = Math.min(90.0, bounds.getNorthEastLat());
        }
        if (bounds.getSouthWestLng() != null && bounds.getNorthEastLng() != null) {
            if (Math.abs(bounds.getSouthWestLng() - bounds.getNorthEastLng()) >= 360.0) {
                southWestLng = -180.0;
                northEastLng = 180.0;
            } else {
                double sw = bounds.getSouthWestLng();
                while (Math.abs(sw) > 180.0) {
                    sw -= Math.signum(sw) * 180.0 * 2.0;
                }
                southWestLng = Math.max(-180.0, sw);
                double ne = bounds.getNorthEastLng();
                while (Math.abs(ne) > 180.0) {
                    ne -= Math.signum(ne) * 180.0 * 2.0;
                }
                northEastLng = Math.min(180.0, ne);
            }
        }
        return new MapBounds(northEastLat, southWestLat, northEastLng, southWestLng);
    }
}

