/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.maps;

import io.github.albertus82.jface.JFaceMessages;
import io.github.albertus82.jface.SwtUtils;
import io.github.albertus82.jface.maps.MapBoundsDialog;
import io.github.albertus82.util.logging.LoggerFactory;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class MapBoundsDialogCreationHelper {
    private static final Logger log = LoggerFactory.getLogger(MapBoundsDialogCreationHelper.class);
    private final MapBoundsDialog dialog;

    public MapBoundsDialogCreationHelper(MapBoundsDialog dialog) {
        this.dialog = dialog;
    }

    public Layout getLayout() {
        int defaultMargin = new GridLayout().marginHeight;
        return GridLayoutFactory.swtDefaults().margins(0, 0).extendedMargins(0, 0, 0, defaultMargin).create();
    }

    public Browser createBrowser(Composite parent, URI uri) {
        Composite borderComposite = new Composite(parent, 0);
        borderComposite.setBackground(parent.getDisplay().getSystemColor(7));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)borderComposite);
        GridLayoutFactory.swtDefaults().applyTo(borderComposite);
        Browser browser = new Browser(borderComposite, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)browser);
        browser.setUrl(uri != null ? uri.toString() : "");
        return browser;
    }

    public Composite createButtonBox(Browser browser) {
        Shell shell = browser.getShell();
        Composite buttonComposite = new Composite((Composite)shell, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(buttonComposite);
        GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).grab(true, false).applyTo((Control)buttonComposite);
        Button confirmButton = new Button(buttonComposite, 8);
        confirmButton.setText(JFaceMessages.get("lbl.button.confirm"));
        GridDataFactory.swtDefaults().align(0x1000000, 4).grab(true, false).minSize(SwtUtils.convertHorizontalDLUsToPixels((Control)confirmButton, 61), -1).applyTo((Control)confirmButton);
        confirmButton.addSelectionListener((SelectionListener)new ButtonListener(0, browser));
        Button cancelButton = new Button(buttonComposite, 8);
        cancelButton.setText(JFaceMessages.get("lbl.button.cancel"));
        GridDataFactory.swtDefaults().align(0x1000000, 4).grab(true, false).minSize(SwtUtils.convertHorizontalDLUsToPixels((Control)cancelButton, 61), -1).applyTo((Control)cancelButton);
        cancelButton.addSelectionListener((SelectionListener)new ButtonListener(1, browser));
        shell.setDefaultButton(confirmButton);
        return buttonComposite;
    }

    private class ButtonListener
    extends SelectionAdapter {
        private final int buttonCode;
        private final Browser browser;

        private ButtonListener(int buttonCode, Browser browser) {
            this.buttonCode = buttonCode;
            this.browser = browser;
        }

        public void widgetSelected(SelectionEvent event) {
            try {
                if (this.buttonCode == 0) {
                    MapBoundsDialogCreationHelper.this.dialog.setOptionValues(this.browser);
                    MapBoundsDialogCreationHelper.this.dialog.setBoundValues(this.browser);
                }
                MapBoundsDialogCreationHelper.this.dialog.setReturnCode(this.buttonCode);
            }
            catch (SWTException e) {
                log.log(Level.FINE, JFaceMessages.get("err.map.retrieve"), e);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, JFaceMessages.get("err.map.retrieve"), e);
            }
            finally {
                Shell shell = this.browser.getShell();
                if (shell != null && !shell.isDisposed()) {
                    shell.close();
                }
            }
        }
    }
}

