/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.maps;

import io.github.albertus82.jface.JFaceMessages;
import io.github.albertus82.jface.SwtUtils;
import io.github.albertus82.jface.maps.LineParser;
import io.github.albertus82.jface.maps.MapMarker;
import io.github.albertus82.jface.maps.MapOptions;
import io.github.albertus82.util.IOUtils;
import io.github.albertus82.util.logging.LoggerFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public abstract class MapDialog
extends Dialog
implements LineParser {
    private static final Logger log = LoggerFactory.getLogger(MapDialog.class);
    public static final String OPTIONS_PLACEHOLDER = "/* {{options}} */";
    public static final String MARKERS_PLACEHOLDER = "/* {{markers}} */";
    public static final String OTHER_PLACEHOLDER = "/* {{other}} */";
    protected static final String HTML_FILE_NAME = "map.html";
    private final Set<MapMarker> markers = new HashSet<MapMarker>();
    private volatile int returnCode = 1;
    private Image[] images;

    protected MapDialog(Shell parent) {
        this(parent, 0x10000410);
    }

    protected MapDialog(Shell parent, int style) {
        super(parent, style);
    }

    public Composite createButtonBox(Browser browser) {
        final Shell shell = browser.getShell();
        Composite buttonComposite = new Composite((Composite)shell, 0);
        GridLayoutFactory.swtDefaults().applyTo(buttonComposite);
        GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).grab(true, false).applyTo((Control)buttonComposite);
        Button closeButton = new Button(buttonComposite, 8);
        closeButton.setText(JFaceMessages.get("lbl.button.close"));
        GridDataFactory.swtDefaults().align(0x1000000, 4).grab(true, false).minSize(SwtUtils.convertHorizontalDLUsToPixels((Control)closeButton, 61), -1).applyTo((Control)closeButton);
        closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                MapDialog.this.setReturnCode(1);
                shell.close();
            }
        });
        shell.setDefaultButton(closeButton);
        return buttonComposite;
    }

    public int open() {
        this.setReturnCode(1);
        Shell shell = new Shell(this.getParent(), this.getStyle());
        shell.setText(this.getText());
        Image[] icons = this.getImages();
        if (icons != null && icons.length > 0) {
            shell.setImages(icons);
        }
        this.createContents(shell);
        Point minimumSize = this.getMinimumSize(shell);
        shell.setSize(this.getSize(shell));
        shell.setMinimumSize(minimumSize);
        shell.open();
        Display display = this.getParent().getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.getReturnCode();
    }

    protected Point getSize(Shell shell) {
        Point normalShellSize = shell.getSize();
        int size = Math.min(normalShellSize.x, normalShellSize.y);
        return new Point(size, size);
    }

    protected Point getMinimumSize(Shell shell) {
        return shell.computeSize(-1, -1, true);
    }

    protected Layout getLayout() {
        return GridLayoutFactory.swtDefaults().create();
    }

    protected void createContents(Shell shell) {
        shell.setLayout(this.getLayout());
        Browser browser = this.createBrowser((Composite)shell);
        this.createButtonBox(browser);
    }

    protected Browser createBrowser(Composite parent) {
        Browser browser = new Browser(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)browser);
        URI pageUri = this.getMapPage((Control)parent);
        browser.setUrl(pageUri != null ? pageUri.toString() : "");
        return browser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URI getMapPage(Control control, InputStream is, LineParser lineParser) {
        URI pageUrl = null;
        File tempFile = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        FileWriter fw = null;
        BufferedWriter bw = null;
        try {
            String line;
            isr = new InputStreamReader(is, StandardCharsets.UTF_8);
            br = new BufferedReader(isr);
            tempFile = File.createTempFile(UUID.randomUUID().toString().replace("-", "").toLowerCase(Locale.ROOT), ".html");
            fw = new FileWriter(tempFile);
            bw = new BufferedWriter(fw);
            while ((line = br.readLine()) != null) {
                if ((line = lineParser.parseLine(line)) == null) continue;
                line = line.trim();
                log.fine(line);
                bw.write(line);
                bw.newLine();
            }
            pageUrl = tempFile.toURI();
        }
        catch (Exception e) {
            try {
                log.log(Level.SEVERE, JFaceMessages.get("err.map.open"), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bw, fw, br, isr);
                throw throwable;
            }
            IOUtils.closeQuietly(bw, fw, br, isr);
        }
        IOUtils.closeQuietly(bw, fw, br, isr);
        if (tempFile != null) {
            final File fileToDelete = tempFile;
            control.addListener(21, new Listener(){

                public void handleEvent(Event event) {
                    try {
                        if (!fileToDelete.delete()) {
                            fileToDelete.deleteOnExit();
                        }
                    }
                    catch (RuntimeException re) {
                        log.log(Level.WARNING, JFaceMessages.get("err.delete.temp", fileToDelete), re);
                    }
                }
            });
        }
        return pageUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URI getMapPage(Control control) {
        URI uRI;
        InputStream is = null;
        try {
            is = this.getClass().getResourceAsStream(HTML_FILE_NAME);
            uRI = MapDialog.getMapPage(control, is, this);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)is);
        return uRI;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public void setReturnCode(int returnCode) {
        this.returnCode = returnCode;
    }

    public Image[] getImages() {
        return this.images;
    }

    public void setImages(Image[] images) {
        this.images = images;
    }

    public Set<MapMarker> getMarkers() {
        return this.markers;
    }

    public abstract MapOptions getOptions();
}

