/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.maps;

import java.io.Serializable;

public class MapMarker
implements Serializable {
    private static final long serialVersionUID = -8178591515901703859L;
    private final double latitude;
    private final double longitude;
    private final String title;

    public MapMarker(double latitude, double longitude, String title) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.title = title != null && !title.trim().isEmpty() ? title.trim() : "";
    }

    public MapMarker(double latitude, double longitude) {
        this(latitude, longitude, null);
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public String getTitle() {
        return this.title;
    }

    public String toString() {
        return "MapMarker [latitude=" + this.latitude + ", longitude=" + this.longitude + ", title=" + this.title + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.latitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.longitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MapMarker)) {
            return false;
        }
        MapMarker other = (MapMarker)obj;
        if (Double.doubleToLongBits(this.latitude) != Double.doubleToLongBits(other.latitude)) {
            return false;
        }
        return Double.doubleToLongBits(this.longitude) == Double.doubleToLongBits(other.longitude);
    }
}

