/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.maps.google;

import io.github.albertus82.jface.JFaceMessages;
import io.github.albertus82.jface.maps.MapDialog;
import io.github.albertus82.jface.maps.MapMarker;
import io.github.albertus82.jface.maps.google.GoogleMapControl;
import io.github.albertus82.jface.maps.google.GoogleMapOptions;
import io.github.albertus82.net.httpserver.html.HtmlUtils;
import io.github.albertus82.util.NewLine;
import java.util.Map;
import org.eclipse.swt.widgets.Shell;

public class GoogleMapDialog
extends MapDialog {
    public static final String DEFAULT_URL = "http://maps.googleapis.com/maps/api/js";
    private final GoogleMapOptions options = new GoogleMapOptions();
    private String url = "http://maps.googleapis.com/maps/api/js";

    public GoogleMapDialog(Shell parent) {
        super(parent);
    }

    public GoogleMapDialog(Shell parent, int style) {
        super(parent, style);
    }

    @Override
    public String parseLine(String line) {
        if (line.contains(DEFAULT_URL) && !JFaceMessages.getLanguage().isEmpty()) {
            return line.replace(DEFAULT_URL, this.url + "?language=" + JFaceMessages.getLanguage());
        }
        if (line.contains("/* {{options}} */")) {
            StringBuilder optionsBlock = new StringBuilder();
            optionsBlock.append('\t').append("center: new google.maps.LatLng(").append(this.options.getCenterLat()).append(", ").append(this.options.getCenterLng()).append("),").append(NewLine.SYSTEM_LINE_SEPARATOR);
            optionsBlock.append('\t').append("zoom: ").append(this.options.getZoom()).append(',').append(NewLine.SYSTEM_LINE_SEPARATOR);
            optionsBlock.append('\t').append("mapTypeId: google.maps.MapTypeId.").append(this.options.getType().name());
            for (Map.Entry<GoogleMapControl, Boolean> control : this.options.getControls().entrySet()) {
                if (control.getKey() == null || control.getValue() == null) continue;
                optionsBlock.append(',').append(NewLine.SYSTEM_LINE_SEPARATOR);
                optionsBlock.append('\t').append(control.getKey().getFieldName()).append(": ").append(control.getValue().toString());
            }
            return optionsBlock.toString();
        }
        if (line.contains("/* {{markers}} */")) {
            if (this.getMarkers().isEmpty()) {
                return null;
            }
            int index = 1;
            StringBuilder markersBlock = new StringBuilder();
            for (MapMarker marker : this.getMarkers()) {
                markersBlock.append("var marker").append(index).append(" = new google.maps.Marker({").append(NewLine.SYSTEM_LINE_SEPARATOR);
                markersBlock.append('\t').append("position: new google.maps.LatLng(").append(marker.getLatitude()).append(", ").append(marker.getLongitude()).append("),").append(NewLine.SYSTEM_LINE_SEPARATOR);
                markersBlock.append('\t').append("map: map,").append(NewLine.SYSTEM_LINE_SEPARATOR);
                markersBlock.append('\t').append("title: '").append(marker.getTitle() == null ? "" : HtmlUtils.escapeEcmaScript(marker.getTitle().trim())).append("'").append(NewLine.SYSTEM_LINE_SEPARATOR);
                markersBlock.append("});").append(NewLine.SYSTEM_LINE_SEPARATOR);
                ++index;
            }
            return markersBlock.toString().trim();
        }
        return line;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public GoogleMapOptions getOptions() {
        return this.options;
    }
}

