/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.maps.google;

import io.github.albertus82.jface.maps.MapOptions;
import io.github.albertus82.jface.maps.google.GoogleMapControl;
import io.github.albertus82.jface.maps.google.GoogleMapType;
import java.util.EnumMap;
import java.util.Map;

public class GoogleMapOptions
extends MapOptions {
    private static final long serialVersionUID = 8324663629284543572L;
    public static final GoogleMapType DEFAULT_TYPE = GoogleMapType.ROADMAP;
    private GoogleMapType type = DEFAULT_TYPE;
    private final Map<GoogleMapControl, Boolean> controls = new EnumMap<GoogleMapControl, Boolean>(GoogleMapControl.class);

    public GoogleMapOptions() {
    }

    public GoogleMapOptions(double centerLat, double centerLng, int zoom, GoogleMapType type) {
        super(centerLat, centerLng, zoom);
        this.type = type;
    }

    public GoogleMapType getType() {
        return this.type;
    }

    public void setType(GoogleMapType type) {
        if (type == null) {
            throw new NullPointerException("type cannot be null");
        }
        this.type = type;
    }

    public Map<GoogleMapControl, Boolean> getControls() {
        return this.controls;
    }

    @Override
    public String toString() {
        return "GoogleMapOptions [centerLat=" + this.getCenterLat() + ", centerLng=" + this.getCenterLng() + ", zoom=" + this.getZoom() + ", type=" + (Object)((Object)this.type) + ", controls=" + this.controls + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.controls.hashCode();
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof GoogleMapOptions)) {
            return false;
        }
        GoogleMapOptions other = (GoogleMapOptions)obj;
        if (!this.controls.equals(other.controls)) {
            return false;
        }
        return this.type == other.type;
    }
}

