/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.maps.leaflet;

import io.github.albertus82.jface.DisplayThreadExecutor;
import io.github.albertus82.jface.JFaceMessages;
import io.github.albertus82.jface.maps.CoordinateUtils;
import io.github.albertus82.jface.maps.MapBounds;
import io.github.albertus82.jface.maps.MapBoundsDialog;
import io.github.albertus82.jface.maps.MapBoundsDialogCreationHelper;
import io.github.albertus82.jface.maps.leaflet.LeafletMapDialog;
import io.github.albertus82.util.logging.LoggerFactory;
import java.text.NumberFormat;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class LeafletMapBoundsDialog
extends LeafletMapDialog
implements MapBoundsDialog {
    private static final String MAP_ONEVENTS_FN = "mapOnEvents";
    private static final Logger log = LoggerFactory.getLogger(LeafletMapBoundsDialog.class);
    private MapBounds bounds = new MapBounds();
    private final MapBoundsDialogCreationHelper helper = new MapBoundsDialogCreationHelper(this);

    public LeafletMapBoundsDialog(Shell parent) {
        super(parent);
    }

    public LeafletMapBoundsDialog(Shell parent, int style) {
        super(parent, style);
    }

    @Override
    protected Layout getLayout() {
        return this.helper.getLayout();
    }

    @Override
    protected void createContents(Shell shell) {
        shell.setLayout(this.getLayout());
        Composite c = new Composite((Composite)shell, 0);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)c);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(c);
        Group latitudeGroup = new Group(c, 0);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)latitudeGroup);
        GridLayoutFactory.swtDefaults().numColumns(4).applyTo((Composite)latitudeGroup);
        latitudeGroup.setText(JFaceMessages.get("lbl.map.bounds.range.latitude"));
        Group longitudeGroup = new Group(c, 0);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)longitudeGroup);
        GridLayoutFactory.swtDefaults().numColumns(4).applyTo((Composite)longitudeGroup);
        longitudeGroup.setText(JFaceMessages.get("lbl.map.bounds.range.longitude"));
        Label southWestLatLabel = new Label((Composite)latitudeGroup, 0);
        GridDataFactory.swtDefaults().applyTo((Control)southWestLatLabel);
        southWestLatLabel.setText(JFaceMessages.get("lbl.map.bounds.range.from"));
        final Text southWestLatText = new Text((Composite)latitudeGroup, 2056);
        southWestLatText.setEditable(false);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)southWestLatText);
        Label northEastLatLabel = new Label((Composite)latitudeGroup, 0);
        GridDataFactory.swtDefaults().applyTo((Control)northEastLatLabel);
        northEastLatLabel.setText(JFaceMessages.get("lbl.map.bounds.range.to"));
        final Text northEastLatText = new Text((Composite)latitudeGroup, 2056);
        northEastLatText.setEditable(false);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)northEastLatText);
        Label southWestLngLabel = new Label((Composite)longitudeGroup, 0);
        GridDataFactory.swtDefaults().applyTo((Control)southWestLngLabel);
        southWestLngLabel.setText(JFaceMessages.get("lbl.map.bounds.range.from"));
        final Text southWestLngText = new Text((Composite)longitudeGroup, 2056);
        southWestLngText.setEditable(false);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)southWestLngText);
        Label northEastLngLabel = new Label((Composite)longitudeGroup, 0);
        GridDataFactory.swtDefaults().applyTo((Control)northEastLngLabel);
        northEastLngLabel.setText(JFaceMessages.get("lbl.map.bounds.range.to"));
        final Text northEastLngText = new Text((Composite)longitudeGroup, 2056);
        northEastLngText.setEditable(false);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)northEastLngText);
        final Browser browser = this.createBrowser((Composite)shell);
        final BrowserFunction function = new BrowserFunction(browser, MAP_ONEVENTS_FN){
            private final NumberFormat formatter;
            {
                super(browser3, name);
                this.formatter = CoordinateUtils.newFormatter();
            }

            public Object function(Object[] arguments) {
                MapBounds mb = MapBounds.normalize(LeafletMapBoundsDialog.getBoundValues(browser));
                if (mb.getSouthWestLat() != null && mb.getNorthEastLat() != null) {
                    southWestLatText.setText(this.formatter.format(mb.getSouthWestLat()));
                    northEastLatText.setText(this.formatter.format(mb.getNorthEastLat()));
                }
                if (mb.getSouthWestLng() != null && mb.getNorthEastLng() != null) {
                    southWestLngText.setText(this.formatter.format(mb.getSouthWestLng()));
                    northEastLngText.setText(this.formatter.format(mb.getNorthEastLng()));
                }
                return null;
            }
        };
        browser.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                function.dispose();
            }
        });
        this.createButtonBox(browser);
        browser.setFocus();
        Thread updateBoundsThread = new Thread(){

            @Override
            public void run() {
                while (!browser.isDisposed()) {
                    try {
                        TimeUnit.SECONDS.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        log.log(Level.FINE, "Interrupted:", e);
                    }
                    new DisplayThreadExecutor((Widget)browser, DisplayThreadExecutor.Mode.SYNC).execute(new Runnable(){

                        @Override
                        public void run() {
                            if (!browser.isDisposed()) {
                                log.log(Level.FINE, "Updating bound fields from map...");
                                try {
                                    function.function(null);
                                    log.log(Level.FINE, "Bound fields updated successfully.");
                                }
                                catch (RuntimeException e) {
                                    log.log(Level.FINE, "Cannot update bound fields from map:", e);
                                }
                            }
                        }
                    });
                }
                log.log(Level.FINE, "Browser disposed -> Terminating {0}", this);
            }
        };
        updateBoundsThread.setDaemon(true);
        updateBoundsThread.setPriority(1);
        updateBoundsThread.start();
    }

    @Override
    protected Browser createBrowser(Composite parent) {
        return this.helper.createBrowser(parent, this.getMapPage((Control)parent));
    }

    @Override
    public Composite createButtonBox(Browser browser) {
        return this.helper.createButtonBox(browser);
    }

    @Override
    public MapBounds getBounds() {
        return this.bounds;
    }

    @Override
    public String parseLine(String line) {
        return LeafletMapBoundsDialog.parseLine(line, this.getOptions(), this.getMarkers(), String.format("map.on('move', function(e) { %s(); }); document.onload = %s();", MAP_ONEVENTS_FN, MAP_ONEVENTS_FN));
    }

    @Override
    public void setOptionValues(Browser browser) {
        this.getOptions().setZoom(((Number)browser.evaluate("return map.getZoom();")).intValue());
        this.getOptions().setCenterLat((Double)browser.evaluate("return map.getCenter().lat;"));
        this.getOptions().setCenterLng((Double)browser.evaluate("return map.getCenter().lng;"));
    }

    @Override
    public void setBoundValues(Browser browser) {
        this.bounds = MapBounds.normalize(LeafletMapBoundsDialog.getBoundValues(browser));
    }

    private static MapBounds getBoundValues(Browser browser) {
        Double northEastLat = (Double)browser.evaluate("return map.getBounds().getNorthEast().lat;");
        Double southWestLat = (Double)browser.evaluate("return map.getBounds().getSouthWest().lat;");
        Double northEastLng = (Double)browser.evaluate("return map.getBounds().getNorthEast().lng;");
        Double southWestLng = (Double)browser.evaluate("return map.getBounds().getSouthWest().lng;");
        return new MapBounds(northEastLat, southWestLat, northEastLng, southWestLng);
    }
}

