/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.maps.leaflet;

import io.github.albertus82.jface.maps.MapDialog;
import io.github.albertus82.jface.maps.MapMarker;
import io.github.albertus82.jface.maps.leaflet.LeafletMapControl;
import io.github.albertus82.jface.maps.leaflet.LeafletMapOptions;
import io.github.albertus82.net.httpserver.html.HtmlUtils;
import io.github.albertus82.util.IOUtils;
import io.github.albertus82.util.NewLine;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import org.eclipse.swt.widgets.Shell;

public class LeafletMapDialog
extends MapDialog {
    private static final String PLACEHOLDER_PREFIX = "/* {{";
    private static final String PLACEHOLDER_SUFFIX = "}} */";
    private final LeafletMapOptions options = new LeafletMapOptions();

    public LeafletMapDialog(Shell parent) {
        super(parent);
    }

    public LeafletMapDialog(Shell parent, int style) {
        super(parent, style);
    }

    public static String parseLine(String line, LeafletMapOptions options, Collection<MapMarker> markers, String other) {
        if (line.contains("/* {{options}} */")) {
            StringBuilder optionsBlock = new StringBuilder();
            optionsBlock.append(String.format("map.setView([%s, %s], %d);", options.getCenterLat(), options.getCenterLng(), options.getZoom()));
            if (!options.getControls().containsKey((Object)LeafletMapControl.LAYERS)) {
                optionsBlock.append(NewLine.SYSTEM_LINE_SEPARATOR);
                optionsBlock.append(String.format("L.tileLayer('%s', { maxZoom: %d, attribution: '%s' }).addTo(map);", HtmlUtils.escapeEcmaScript("https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png"), 19, HtmlUtils.escapeEcmaScript("&copy; <a href=\"https://www.openstreetmap.org/copyright\">OpenStreetMap</a>")));
            }
            for (Map.Entry<LeafletMapControl, String> control : options.getControls().entrySet()) {
                optionsBlock.append(NewLine.SYSTEM_LINE_SEPARATOR);
                optionsBlock.append(String.format("map.addControl(L.control.%s(%s));", control.getKey().getConstructor(), control.getValue() == null ? "" : control.getValue().trim()));
            }
            return optionsBlock.toString().trim();
        }
        if (line.contains("/* {{markers}} */")) {
            if (markers == null || markers.isEmpty()) {
                return null;
            }
            StringBuilder markersBlock = new StringBuilder();
            for (MapMarker marker : markers) {
                markersBlock.append(String.format("L.marker([%s, %s]).addTo(map).bindPopup('%s');", marker.getLatitude(), marker.getLongitude(), marker.getTitle() == null ? "" : HtmlUtils.escapeEcmaScript(marker.getTitle().replace(NewLine.SYSTEM_LINE_SEPARATOR, "<br />").trim())));
                markersBlock.append(NewLine.SYSTEM_LINE_SEPARATOR);
            }
            return markersBlock.toString().trim();
        }
        if (line.contains("/* {{other}} */")) {
            if (other == null || other.isEmpty()) {
                return null;
            }
            return other;
        }
        if (line.contains(PLACEHOLDER_PREFIX) && line.indexOf(PLACEHOLDER_PREFIX) == line.lastIndexOf(PLACEHOLDER_PREFIX) && line.contains(PLACEHOLDER_SUFFIX) && line.indexOf(PLACEHOLDER_SUFFIX) == line.lastIndexOf(PLACEHOLDER_SUFFIX) && line.indexOf(PLACEHOLDER_SUFFIX) > line.indexOf(PLACEHOLDER_PREFIX)) {
            String resourceName = line.substring(line.indexOf(PLACEHOLDER_PREFIX) + PLACEHOLDER_PREFIX.length(), line.indexOf(PLACEHOLDER_SUFFIX));
            String resource = LeafletMapDialog.readAllResource(resourceName);
            if (resource != null) {
                return resource;
            }
            return line;
        }
        return line;
    }

    private static String readAllResource(String resourceName) {
        BufferedReader br;
        InputStreamReader isr;
        InputStream is;
        StringBuilder buf;
        block6: {
            buf = new StringBuilder();
            is = null;
            isr = null;
            br = null;
            is = LeafletMapDialog.class.getResourceAsStream(resourceName);
            if (is != null) break block6;
            String string = null;
            IOUtils.closeQuietly(br, isr, is);
            return string;
        }
        try {
            isr = new InputStreamReader(is, StandardCharsets.UTF_8);
            br = new BufferedReader(isr);
            String line = null;
            while ((line = br.readLine()) != null) {
                buf.append(line).append((Object)NewLine.CRLF);
            }
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(br, isr, is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(br, isr, is);
        return buf.toString().trim();
    }

    @Override
    public String parseLine(String line) {
        return LeafletMapDialog.parseLine(line, this.getOptions(), this.getMarkers(), null);
    }

    @Override
    public LeafletMapOptions getOptions() {
        return this.options;
    }
}

