/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.preference;

import io.github.albertus82.jface.preference.IPreference;
import io.github.albertus82.jface.preference.IPreferencesCallback;
import io.github.albertus82.jface.preference.page.BasePreferencePage;
import io.github.albertus82.jface.preference.page.IPageDefinition;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceNode;

public class ConfigurationNode
extends PreferenceNode {
    private final IPageDefinition pageDefinition;
    private final IPreference[] preferences;
    private final IPreferencesCallback preferencesCallback;

    public ConfigurationNode(IPageDefinition pageDefinition, IPreference[] preferences, IPreferencesCallback preferencesCallback) {
        super(pageDefinition.getNodeId(), pageDefinition.getLabel().replace("&&", "&"), pageDefinition.getImage(), pageDefinition.getPageClass() != null ? pageDefinition.getPageClass().getName() : null);
        this.pageDefinition = pageDefinition;
        this.preferences = preferences;
        this.preferencesCallback = preferencesCallback;
    }

    public void createPage() {
        BasePreferencePage page;
        Class<? extends BasePreferencePage> pageClass = this.pageDefinition.getPageClass();
        if (pageClass != null) {
            try {
                page = pageClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        } else {
            page = new BasePreferencePage();
        }
        this.setPage((IPreferencePage)page);
        if (this.getLabelImage() != null) {
            page.setImageDescriptor(this.getImageDescriptor());
        }
        page.setTitle(this.pageDefinition.getLabel());
        page.setPreferences(this.preferences);
        page.setPreferencesCallback(this.preferencesCallback);
        page.setPageDefinition(this.pageDefinition);
    }

    public BasePreferencePage getPage() {
        return (BasePreferencePage)super.getPage();
    }
}

