/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.preference;

import io.github.albertus82.util.config.Configuration;
import io.github.albertus82.util.logging.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.preference.PreferenceStore;

public class ConfigurationStore
extends PreferenceStore {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationStore.class);
    protected final String filename;

    public ConfigurationStore(String filename) {
        super(filename);
        this.filename = filename;
    }

    public void save() throws IOException {
        File parentFile = new File(this.filename).getParentFile();
        if (parentFile != null && !parentFile.exists()) {
            parentFile.mkdirs();
        }
        super.save();
    }

    public boolean getBoolean(String name) {
        return Configuration.parseBoolean(this.getString(name).trim());
    }

    public boolean getDefaultBoolean(String name) {
        return Configuration.parseBoolean(this.getDefaultString(name).trim());
    }

    public int getInt(String name) {
        try {
            return Integer.parseInt(this.getString(name).trim());
        }
        catch (NumberFormatException e) {
            log.log(Level.FINEST, "The value provided does not contain a parsable int:", e);
            return 0;
        }
    }

    public int getDefaultInt(String name) {
        try {
            return Integer.parseInt(this.getDefaultString(name).trim());
        }
        catch (NumberFormatException e) {
            log.log(Level.FINEST, "The value provided does not contain a parsable int:", e);
            return 0;
        }
    }

    public long getLong(String name) {
        try {
            return Long.parseLong(this.getString(name).trim());
        }
        catch (NumberFormatException e) {
            log.log(Level.FINEST, "The value provided does not contain a parsable long:", e);
            return 0L;
        }
    }

    public long getDefaultLong(String name) {
        try {
            return Long.parseLong(this.getDefaultString(name).trim());
        }
        catch (NumberFormatException e) {
            log.log(Level.FINEST, "The value provided does not contain a parsable long:", e);
            return 0L;
        }
    }

    public float getFloat(String name) {
        try {
            return Float.parseFloat(this.getString(name).trim());
        }
        catch (NumberFormatException e) {
            log.log(Level.FINEST, "The value provided does not contain a parsable float:", e);
            return 0.0f;
        }
    }

    public float getDefaultFloat(String name) {
        try {
            return Float.parseFloat(this.getDefaultString(name).trim());
        }
        catch (NumberFormatException e) {
            log.log(Level.FINEST, "The value provided does not contain a parsable float:", e);
            return 0.0f;
        }
    }

    public double getDouble(String name) {
        try {
            return Double.parseDouble(this.getString(name).trim());
        }
        catch (NumberFormatException e) {
            log.log(Level.FINEST, "The value provided does not contain a parsable double:", e);
            return 0.0;
        }
    }

    public double getDefaultDouble(String name) {
        try {
            return Double.parseDouble(this.getDefaultString(name).trim());
        }
        catch (NumberFormatException e) {
            log.log(Level.FINEST, "The value provided does not contain a parsable double:", e);
            return 0.0;
        }
    }
}

