/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.preference;

import io.github.albertus82.jface.EnhancedErrorDialog;
import io.github.albertus82.jface.JFaceMessages;
import io.github.albertus82.jface.preference.page.BasePreferencePage;
import io.github.albertus82.util.logging.LoggerFactory;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

public class EnhancedPreferenceDialog
extends PreferenceDialog {
    private static final Logger log = LoggerFactory.getLogger(EnhancedPreferenceDialog.class);
    private final String title;
    private final Image[] images;

    public EnhancedPreferenceDialog(Shell parentShell, PreferenceManager manager, String title, Image ... images) {
        super(parentShell, manager);
        this.title = title;
        this.images = images;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.title != null) {
            newShell.setText(this.title);
        }
        if (this.images != null && this.images.length > 0) {
            newShell.setImages(this.images);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        Button okButton = this.getButton(0);
        okButton.setText(JFaceMessages.get("lbl.button.ok"));
        Button cancelButton = this.getButton(1);
        cancelButton.setText(JFaceMessages.get("lbl.button.cancel"));
    }

    protected boolean showPage(IPreferenceNode node) {
        boolean success = super.showPage(node);
        IPreferencePage currentPage = this.getCurrentPage();
        if (currentPage instanceof BasePreferencePage) {
            ((BasePreferencePage)currentPage).updateCrossChildrenStatus();
        }
        return success;
    }

    protected void constrainShellSize() {
        super.constrainShellSize();
        if (Util.isCocoa()) {
            Tree tree = this.getTreeViewer().getTree();
            final FontDescriptor treeFontDescriptor = FontDescriptor.createFrom((Font)JFaceResources.getBannerFont()).setStyle(0);
            final Font treeFont = treeFontDescriptor.createFont((Device)tree.getDisplay());
            this.updateTreeFont(treeFont);
            tree.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    treeFontDescriptor.destroyFont(treeFont);
                }
            });
        }
    }

    protected void handleSave() {
        for (IPreferenceNode node : this.getPreferenceManager().getElements(0)) {
            IPreferenceStore store;
            IPreferencePage page = node.getPage();
            if (!(page instanceof PreferencePage) || (store = ((PreferencePage)page).getPreferenceStore()) == null || !store.needsSaving() || !(store instanceof IPersistentPreferenceStore)) continue;
            try {
                ((IPersistentPreferenceStore)store).save();
            }
            catch (IOException ioe) {
                String message = JFaceMessages.get("err.preferences.save");
                log.log(Level.SEVERE, message, ioe);
                EnhancedErrorDialog.openError(this.getShell(), this.title, message, 4, ioe, Display.getCurrent().getSystemImage(1));
            }
        }
    }
}

