/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.preference;

import io.github.albertus82.jface.JFaceMessages;
import io.github.albertus82.jface.preference.FieldEditorDetails;
import io.github.albertus82.jface.preference.field.BigDecimalComboFieldEditor;
import io.github.albertus82.jface.preference.field.BigDecimalFieldEditor;
import io.github.albertus82.jface.preference.field.BigIntegerComboFieldEditor;
import io.github.albertus82.jface.preference.field.BigIntegerFieldEditor;
import io.github.albertus82.jface.preference.field.ByteComboFieldEditor;
import io.github.albertus82.jface.preference.field.ByteFieldEditor;
import io.github.albertus82.jface.preference.field.DateFieldEditor;
import io.github.albertus82.jface.preference.field.DefaultBooleanFieldEditor;
import io.github.albertus82.jface.preference.field.DefaultComboFieldEditor;
import io.github.albertus82.jface.preference.field.DefaultRadioGroupFieldEditor;
import io.github.albertus82.jface.preference.field.DelimiterComboFieldEditor;
import io.github.albertus82.jface.preference.field.DoubleComboFieldEditor;
import io.github.albertus82.jface.preference.field.DoubleFieldEditor;
import io.github.albertus82.jface.preference.field.EditableComboFieldEditor;
import io.github.albertus82.jface.preference.field.EmailAddressesListEditor;
import io.github.albertus82.jface.preference.field.EnhancedDirectoryFieldEditor;
import io.github.albertus82.jface.preference.field.EnhancedFileFieldEditor;
import io.github.albertus82.jface.preference.field.EnhancedIntegerFieldEditor;
import io.github.albertus82.jface.preference.field.EnhancedStringFieldEditor;
import io.github.albertus82.jface.preference.field.FieldEditorDefault;
import io.github.albertus82.jface.preference.field.FloatComboFieldEditor;
import io.github.albertus82.jface.preference.field.FloatFieldEditor;
import io.github.albertus82.jface.preference.field.IntegerComboFieldEditor;
import io.github.albertus82.jface.preference.field.ListFieldEditor;
import io.github.albertus82.jface.preference.field.LocalizedPathEditor;
import io.github.albertus82.jface.preference.field.LongComboFieldEditor;
import io.github.albertus82.jface.preference.field.LongFieldEditor;
import io.github.albertus82.jface.preference.field.PasswordFieldEditor;
import io.github.albertus82.jface.preference.field.ScaleIntegerFieldEditor;
import io.github.albertus82.jface.preference.field.ShortComboFieldEditor;
import io.github.albertus82.jface.preference.field.ShortFieldEditor;
import io.github.albertus82.jface.preference.field.UriListEditor;
import io.github.albertus82.jface.preference.field.ValidatedComboFieldEditor;
import io.github.albertus82.jface.preference.field.WrapStringFieldEditor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.FontFieldEditor;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PathEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.ScaleFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class FieldEditorFactory {
    private boolean boldCustomValues = true;

    public boolean isBoldCustomValues() {
        return this.boldCustomValues;
    }

    public void setBoldCustomValues(boolean boldCustomValues) {
        this.boldCustomValues = boldCustomValues;
    }

    public FieldEditor createFieldEditor(String name, String label, Composite parent, FieldEditorDetails details) {
        Object fieldEditor;
        Class<? extends FieldEditor> type = details.getFieldEditorClass();
        if (BigIntegerComboFieldEditor.class.equals(type)) {
            fieldEditor = this.createBigIntegerComboFieldEditor(name, label, parent, details);
        } else if (BigDecimalComboFieldEditor.class.equals(type)) {
            fieldEditor = this.createBigDecimalComboFieldEditor(name, label, parent, details);
        } else if (BooleanFieldEditor.class.equals(type)) {
            fieldEditor = new BooleanFieldEditor(name, label, parent);
        } else if (ColorFieldEditor.class.equals(type)) {
            fieldEditor = new ColorFieldEditor(name, label, parent);
        } else if (ComboFieldEditor.class.equals(type)) {
            fieldEditor = new ComboFieldEditor(name, label, details.getLabelsAndValues().toArray(), parent);
        } else if (BigDecimalFieldEditor.class.equals(type)) {
            fieldEditor = this.createBigDecimalFieldEditor(name, label, parent, details);
        } else if (BigIntegerFieldEditor.class.equals(type)) {
            fieldEditor = this.createBigIntegerFieldEditor(name, label, parent, details);
        } else if (DefaultBooleanFieldEditor.class.equals(type)) {
            fieldEditor = new DefaultBooleanFieldEditor(name, label, parent);
        } else if (DefaultComboFieldEditor.class.equals(type)) {
            fieldEditor = new DefaultComboFieldEditor(name, label, details.getLabelsAndValues().toArray(), parent);
        } else if (DateFieldEditor.class.equals(type)) {
            fieldEditor = this.createDateFieldEditor(name, label, parent, details);
        } else if (EnhancedDirectoryFieldEditor.class.equals(type)) {
            fieldEditor = this.createEnhancedDirectoryFieldEditor(name, label, parent, details);
        } else if (DoubleFieldEditor.class.equals(type)) {
            fieldEditor = this.createDoubleFieldEditor(name, label, parent, details);
        } else if (EnhancedFileFieldEditor.class.equals(type)) {
            fieldEditor = this.createEnhancedFileFieldEditor(name, label, parent, details);
        } else if (FloatFieldEditor.class.equals(type)) {
            fieldEditor = this.createFloatFieldEditor(name, label, parent, details);
        } else if (EnhancedIntegerFieldEditor.class.equals(type)) {
            fieldEditor = this.createEnhancedIntegerFieldEditor(name, label, parent, details);
        } else if (ListFieldEditor.class.equals(type)) {
            fieldEditor = this.createListFieldEditor(name, label, parent, details);
        } else if (LongFieldEditor.class.equals(type)) {
            fieldEditor = this.createLongFieldEditor(name, label, parent, details);
        } else if (ShortFieldEditor.class.equals(type)) {
            fieldEditor = this.createShortFieldEditor(name, label, parent, details);
        } else if (ByteFieldEditor.class.equals(type)) {
            fieldEditor = this.createByteFieldEditor(name, label, parent, details);
        } else if (DefaultRadioGroupFieldEditor.class.equals(type)) {
            fieldEditor = this.createDefaultRadioGroupFieldEditor(name, label, parent, details);
        } else if (EnhancedStringFieldEditor.class.equals(type)) {
            fieldEditor = this.createEnhancedStringFieldEditor(name, label, parent, details);
        } else if (DelimiterComboFieldEditor.class.equals(type)) {
            fieldEditor = this.createDelimiterComboFieldEditor(name, label, parent, details);
        } else if (DirectoryFieldEditor.class.equals(type)) {
            fieldEditor = this.createDirectoryFieldEditor(name, label, parent, details);
        } else if (DoubleComboFieldEditor.class.equals(type)) {
            fieldEditor = this.createDoubleComboFieldEditor(name, label, parent, details);
        } else if (EditableComboFieldEditor.class.equals(type)) {
            fieldEditor = new EditableComboFieldEditor(name, label, details.getLabelsAndValues().toArray(), parent);
        } else if (EmailAddressesListEditor.class.equals(type)) {
            fieldEditor = this.createEmailAddressesListEditor(name, label, parent, details);
        } else if (FileFieldEditor.class.equals(type)) {
            fieldEditor = this.createFileFieldEditor(name, label, parent, details);
        } else if (FloatComboFieldEditor.class.equals(type)) {
            fieldEditor = this.createFloatComboFieldEditor(name, label, parent, details);
        } else if (FontFieldEditor.class.equals(type)) {
            fieldEditor = this.createFontFieldEditor(name, label, parent, details);
        } else if (IntegerFieldEditor.class.equals(type)) {
            fieldEditor = this.createIntegerFieldEditor(name, label, parent, details);
        } else if (IntegerComboFieldEditor.class.equals(type)) {
            fieldEditor = this.createIntegerComboFieldEditor(name, label, parent, details);
        } else if (LocalizedPathEditor.class.equals(type)) {
            fieldEditor = this.createLocalizedPathEditor(name, label, parent, details);
        } else if (LongComboFieldEditor.class.equals(type)) {
            fieldEditor = this.createLongComboFieldEditor(name, label, parent, details);
        } else if (PasswordFieldEditor.class.equals(type)) {
            fieldEditor = this.createPasswordFieldEditor(name, label, parent, details);
        } else if (PathEditor.class.equals(type)) {
            fieldEditor = new PathEditor(name, label, details.getDirectoryDialogMessage() != null ? details.getDirectoryDialogMessage().toString() : null, parent);
        } else if (RadioGroupFieldEditor.class.equals(type)) {
            fieldEditor = this.createRadioGroupFieldEditor(name, label, parent, details);
        } else if (ScaleFieldEditor.class.equals(type)) {
            fieldEditor = this.createScaleFieldEditor(name, label, parent, details);
        } else if (ScaleIntegerFieldEditor.class.equals(type)) {
            fieldEditor = this.createScaleIntegerFieldEditor(name, label, parent, details);
        } else if (ShortComboFieldEditor.class.equals(type)) {
            fieldEditor = this.createShortComboFieldEditor(name, label, parent, details);
        } else if (ByteComboFieldEditor.class.equals(type)) {
            fieldEditor = this.createByteComboFieldEditor(name, label, parent, details);
        } else if (StringFieldEditor.class.equals(type)) {
            fieldEditor = this.createStringFieldEditor(name, label, parent, details);
        } else if (UriListEditor.class.equals(type)) {
            fieldEditor = this.createUriListEditor(name, label, parent, details);
        } else if (ValidatedComboFieldEditor.class.equals(type)) {
            fieldEditor = this.createValidatedComboFieldEditor(name, label, parent, details);
        } else if (WrapStringFieldEditor.class.equals(type)) {
            fieldEditor = this.createWrapStringFieldEditor(name, label, parent, details);
        } else {
            throw new IllegalArgumentException("Unsupported FieldEditor: " + type);
        }
        this.postConstruct((FieldEditor)fieldEditor, details, parent);
        return fieldEditor;
    }

    protected void postConstruct(FieldEditor fieldEditor, FieldEditorDetails details, Composite parent) {
        if (details != null) {
            if (fieldEditor instanceof FieldEditorDefault) {
                FieldEditorDefault fieldEditorDefault = (FieldEditorDefault)fieldEditor;
                if (details.getDefaultToolTip() != null) {
                    fieldEditorDefault.setDefaultToolTip(details.getDefaultToolTip());
                }
                if (!this.isBoldCustomValues()) {
                    fieldEditorDefault.setBoldCustomValues(false);
                } else if (details.getBoldCustomValues() != null) {
                    fieldEditorDefault.setBoldCustomValues(details.getBoldCustomValues());
                }
            }
            if (details.isDisabled()) {
                fieldEditor.setEnabled(false, parent);
            }
        }
    }

    protected BigIntegerComboFieldEditor createBigIntegerComboFieldEditor(String name, String label, Composite parent, FieldEditorDetails details) {
        BigIntegerComboFieldEditor fieldEditor = new BigIntegerComboFieldEditor(name, label, details.getLabelsAndValues().toArray(), parent);
        if (details.getEmptyStringAllowed() != null) {
            fieldEditor.setEmptyStringAllowed(details.getEmptyStringAllowed());
        }
        if (details.getNumberMinimum() == null || details.getNumberMinimum() instanceof BigInteger) {
            fieldEditor.setMinValidValue((BigInteger)details.getNumberMinimum());
        } else {
            fieldEditor.setMinValidValue(BigInteger.valueOf(details.getNumberMinimum().longValue()));
        }
        if (details.getNumberMaximum() == null || details.getNumberMaximum() instanceof BigInteger) {
            fieldEditor.setMaxValidValue((BigInteger)details.getNumberMaximum());
        } else {
            fieldEditor.setMaxValidValue(BigInteger.valueOf(details.getNumberMaximum().longValue()));
        }
        if (details.getTextLimit() != null) {
            fieldEditor.setTextLimit(details.getTextLimit());
        }
        return fieldEditor;
    }

    protected BigDecimalComboFieldEditor createBigDecimalComboFieldEditor(String name, String label, Composite parent, FieldEditorDetails details) {
        BigDecimalComboFieldEditor fieldEditor = new BigDecimalComboFieldEditor(name, label, details.getLabelsAndValues().toArray(), parent);
        if (details.getEmptyStringAllowed() != null) {
            fieldEditor.setEmptyStringAllowed(details.getEmptyStringAllowed());
        }
        if (details.getNumberMinimum() == null || details.getNumberMinimum() instanceof BigDecimal) {
            fieldEditor.setMinValidValue((BigDecimal)details.getNumberMinimum());
        } else {
            fieldEditor.setMinValidValue(BigDecimal.valueOf(details.getNumberMinimum().doubleValue()));
        }
        if (details.getNumberMaximum() == null || details.getNumberMaximum() instanceof BigDecimal) {
            fieldEditor.setMaxValidValue((BigDecimal)details.getNumberMaximum());
        } else {
            fieldEditor.setMaxValidValue(BigDecimal.valueOf(details.getNumberMaximum().doubleValue()));
        }
        if (details.getTextLimit() != null) {
            fieldEditor.setTextLimit(details.getTextLimit());
        }
        return fieldEditor;
    }

    protected BigDecimalFieldEditor createBigDecimalFieldEditor(String name, String label, Composite parent, FieldEditorDetails details) {
        BigDecimalFieldEditor fieldEditor = new BigDecimalFieldEditor(name, label, parent);
        if (details != null) {
            Number max;
            Number min;
            if (details.getEmptyStringAllowed() != null) {
                fieldEditor.setEmptyStringAllowed(details.getEmptyStringAllowed());
            }
            if ((min = details.getNumberMinimum()) != null) {
                fieldEditor.setMinValidValue(min instanceof BigDecimal ? (BigDecimal)min : BigDecimal.valueOf(min.doubleValue()));
            }
            if ((max = details.getNumberMaximum()) != null) {
                fieldEditor.setMaxValidValue(max instanceof BigDecimal ? (BigDecimal)max : BigDecimal.valueOf(max.doubleValue()));
            }
            if (details.getTextLimit() != null) {
                fieldEditor.setTextLimit(details.getTextLimit());
            }
        }
        return fieldEditor;
    }

    protected BigIntegerFieldEditor createBigIntegerFieldEditor(String name, String label, Composite parent, FieldEditorDetails details) {
        BigIntegerFieldEditor fieldEditor = new BigIntegerFieldEditor(name, label, parent);
        if (details != null) {
            Number max;
            Number min;
            if (details.getEmptyStringAllowed() != null) {
                fieldEditor.setEmptyStringAllowed(details.getEmptyStringAllowed());
            }
            if ((min = details.getNumberMinimum()) != null) {
                fieldEditor.setMinValidValue(min instanceof BigInteger ? (BigInteger)min : BigInteger.valueOf(min.longValue()));
            }
            if ((max = details.getNumberMaximum()) != null) {
                fieldEditor.setMaxValidValue(max instanceof BigInteger ? (BigInteger)max : BigInteger.valueOf(max.longValue()));
            }
            if (details.getTextLimit() != null) {
                fieldEditor.setTextLimit(details.getTextLimit());
            }
        }
        return fieldEditor;
    }

    protected ByteComboFieldEditor createByteComboFieldEditor(String name, String label, Composite parent, FieldEditorDetails details) {
        ByteComboFieldEditor fieldEditor = new ByteComboFieldEditor(name, label, details.getLabelsAndValues().toArray(), parent);
        if (details.getEmptyStringAllowed() != null) {
            fieldEditor.setEmptyStringAllowed(details.getEmptyStringAllowed());
        }
        if (details.getNumberMinimum() != null) {
            fieldEditor.setMinValidValue(details.getNumberMinimum().byteValue());
        }
        if (details.getNumberMaximum() != null) {
            fieldEditor.setMaxValidValue(details.getNumberMaximum().byteValue());
        }
        if (details.getTextLimit() != null) {
            fieldEditor.setTextLimit(details.getTextLimit());
        }
        return fieldEditor;
    }

    protected ByteFieldEditor createByteFieldEditor(String name, String label, Composite parent, FieldEditorDetails details) {
        ByteFieldEditor fieldEditor = new ByteFieldEditor(name, label, parent);
        if (details != null) {
            if (details.getEmptyStringAllowed() != null) {
                fieldEditor.setEmptyStringAllowed(details.getEmptyStringAllowed());
            }
            if (details.getNumberMinimum() != null) {
                fieldEditor.setMinValidValue(details.getNumberMinimum().byteValue());
            }
            if (details.getNumberMaximum() != null) {
                fieldEditor.setMaxValidValue(details.getNumberMaximum().byteValue());
            }
            if (details.getTextLimit() != null) {
                fieldEditor.setTextLimit(details.getTextLimit());
            }
        }
        return fieldEditor;
    }

    protected DateFieldEditor createDateFieldEditor(String name, String label, Composite parent, FieldEditorDetails details) {
        int style;
        int n = style = details.getStyle() != null ? details.getStyle() : 0;
        DateFieldEditor fieldEditor = details.getTextWidth() != null && details.getTextValidateStrategy() != null ? new DateFieldEditor(name, label, details.getDatePattern(), style, details.getTextWidth(), details.getTextValidateStrategy(), parent) : (details.getTextValidateStrategy() != null ? new DateFieldEditor(name, label, details.getDatePattern(), style, StringFieldEditor.UNLIMITED, details.getTextValidateStrategy(), parent) : (details.getTextWidth() != null ? new DateFieldEditor(name, label, details.getDatePattern(), style, details.getTextWidth(), parent) : new DateFieldEditor(name, label, details.getDatePattern(), style, parent)));
        if (details.getEmptyStringAllowed() != null) {
            fieldEditor.setEmptyStringAllowed(details.getEmptyStringAllowed());
        }
        if (details.getDateFrom() != null) {
            fieldEditor.setMinValidValue(details.getDateFrom());
        }
        if (details.getDateTo() != null) {
            fieldEditor.setMaxValidValue(details.getDateTo());
        }
        if (details.getTextLimit() != null) {
            fieldEditor.setTextLimit(details.getTextLimit());
        }
        return fieldEditor;
    }

    protected EnhancedDirectoryFieldEditor createEnhancedDirectoryFieldEditor(String name, String label, Composite parent, FieldEditorDetails details) {
        EnhancedDirectoryFieldEditor fieldEditor = new EnhancedDirectoryFieldEditor(name, label, parent);
        if (details != null) {
            if (details.getTextLimit() != null) {
                fieldEditor.setTextLimit(details.getTextLimit());
            }
            if (details.getEmptyStringAllowed() != null) {
                fieldEditor.setEmptyStringAllowed(details.getEmptyStringAllowed());
            }
            if (details.getDirectoryDialogMessage() != null) {
                fieldEditor.setDialogMessage(details.getDirectoryDialogMessage());
            }
            if (details.getDirectoryMustExist() != null) {
                fieldEditor.setCheckExistence(details.getDirectoryMustExist());
            }
        }
        return fieldEditor;
    }

    protected DoubleFieldEditor createDoubleFieldEditor(String name, String label, Composite parent, FieldEditorDetails details) {
        DoubleFieldEditor fieldEditor = new DoubleFieldEditor(name, label, parent);
        if (details != null) {
            if (details.getEmptyStringAllowed() != null) {
                fieldEditor.setEmptyStringAllowed(details.getEmptyStringAllowed());
            }
            if (details.getNumberMinimum() != null) {
                fieldEditor.setMinValidValue(details.getNumberMinimum().doubleValue());
            }
            if (details.getNumberMaximum() != null) {
                fieldEditor.setMaxValidValue(details.getNumberMaximum().doubleValue());
            }
            if (details.getTextLimit() != null) {
                fieldEditor.setTextLimit(details.getTextLimit());
            }
        }
        return fieldEditor;
    }

    protected EnhancedFileFieldEditor createEnhancedFileFieldEditor(String name, String label, Composite parent, FieldEditorDetails details) {
        EnhancedFileFieldEditor fieldEditor = details != null && details.getFileEnforceAbsolute() != null ? new EnhancedFileFieldEditor(name, label, details.getFileEnforceAbsolute(), parent) : new EnhancedFileFieldEditor(name, label, parent);
        if (details != null) {
            if (details.getTextLimit() != null) {
                fieldEditor.setTextLimit(details.getTextLimit());
            }
            if (details.getEmptyStringAllowed() != null) {
                fieldEditor.setEmptyStringAllowed(details.getEmptyStringAllowed());
            }
            if (details.getFileExtensions() != null && details.getFileExtensions().length != 0) {
                fieldEditor.setFileExtensions(details.getFileExtensions());
            }
        }
        return fieldEditor;
    }

    protected FloatFieldEditor createFloatFieldEditor(String name, String label, Composite parent, FieldEditorDetails details) {
        FloatFieldEditor fieldEditor = new FloatFieldEditor(name, label, parent);
        if (details != null) {
            if (details.getEmptyStringAllowed() != null) {
                fieldEditor.setEmptyStringAllowed(details.getEmptyStringAllowed());
            }
            if (details.getNumberMinimum() != null) {
                fieldEditor.setMinValidValue(Float.valueOf(details.getNumberMinimum().floatValue()));
            }
            if (details.getNumberMaximum() != null) {
                fieldEditor.setMaxValidValue(Float.valueOf(details.getNumberMaximum().floatValue()));
            }
            if (details.getTextLimit() != null) {
                fieldEditor.setTextLimit(details.getTextLimit());
            }
        }
        return fieldEditor;
    }

    protected EnhancedIntegerFieldEditor createEnhancedIntegerFieldEditor(String name, String label, Composite parent, FieldEditorDetails details) {
        EnhancedIntegerFieldEditor fieldEditor = new EnhancedIntegerFieldEditor(name, label, parent);
        if (details != null) {
            if (details.getEmptyStringAllowed() != null) {
                fieldEditor.setEmptyStringAllowed(details.getEmptyStringAllowed());
            }
            if (details.getNumberMinimum() != null) {
                fieldEditor.setMinValidValue(details.getNumberMinimum().intValue());
            }
            if (details.getNumberMaximum() != null) {
                fieldEditor.setMaxValidValue(details.getNumberMaximum().intValue());
            }
            if (details.getTextLimit() != null) {
                fieldEditor.setTextLimit(details.getTextLimit());
            }
        }
        return fieldEditor;
    }

    protected FieldEditor createListFieldEditor(String name, String label, Composite parent, FieldEditorDetails details) {
        if (details.getHeight() != null) {
            return new ListFieldEditor(name, label, details.getLabelsAndValues().toArray(), details.getHeight(), parent);
        }
        return new ListFieldEditor(name, label, details.getLabelsAndValues().toArray(), parent);
    }

    protected LongFieldEditor createLongFieldEditor(String name, String label, Composite parent, FieldEditorDetails details) {
        LongFieldEditor fieldEditor = new LongFieldEditor(name, label, parent);
        if (details != null) {
            if (details.getEmptyStringAllowed() != null) {
                fieldEditor.setEmptyStringAllowed(details.getEmptyStringAllowed());
            }
            if (details.getNumberMinimum() != null) {
                fieldEditor.setMinValidValue(details.getNumberMinimum().longValue());
            }
            if (details.getNumberMaximum() != null) {
                fieldEditor.setMaxValidValue(details.getNumberMaximum().longValue());
            }
            if (details.getTextLimit() != null) {
                fieldEditor.setTextLimit(details.getTextLimit());
            }
        }
        return fieldEditor;
    }

    protected DefaultRadioGroupFieldEditor createDefaultRadioGroupFieldEditor(String name, String label, Composite parent, FieldEditorDetails details) {
        if (details.getRadioUseGroup() != null) {
            return new DefaultRadioGroupFieldEditor(name, label, details.getRadioNumColumns(), details.getLabelsAndValues().toArray(), parent, details.getRadioUseGroup());
        }
        return new DefaultRadioGroupFieldEditor(name, label, details.getRadioNumColumns(), details.getLabelsAndValues().toArray(), parent);
    }

    protected EnhancedStringFieldEditor createEnhancedStringFieldEditor(String name, String label, Composite parent, FieldEditorDetails details) {
        EnhancedStringFieldEditor fieldEditor = details != null && details.getTextWidth() != null && details.getTextValidateStrategy() != null ? new EnhancedStringFieldEditor(name, label, details.getTextWidth(), details.getTextValidateStrategy(), parent) : (details != null && details.getTextValidateStrategy() != null ? new EnhancedStringFieldEditor(name, label, StringFieldEditor.UNLIMITED, details.getTextValidateStrategy(), parent) : (details != null && details.getTextWidth() != null ? new EnhancedStringFieldEditor(name, label, details.getTextWidth(), parent) : new EnhancedStringFieldEditor(name, label, parent)));
        if (details != null) {
            if (details.getEmptyStringAllowed() != null) {
                fieldEditor.setEmptyStringAllowed(details.getEmptyStringAllowed());
            }
            if (details.getTextLimit() != null) {
                fieldEditor.setTextLimit(details.getTextLimit());
            }
        }
        return fieldEditor;
    }

    protected DelimiterComboFieldEditor createDelimiterComboFieldEditor(String name, String label, Composite parent, FieldEditorDetails details) {
        DelimiterComboFieldEditor fieldEditor = new DelimiterComboFieldEditor(name, label, details.getLabelsAndValues().toArray(), parent);
        if (details.getEmptyStringAllowed() != null) {
            fieldEditor.setEmptyStringAllowed(details.getEmptyStringAllowed());
        }
        return fieldEditor;
    }

    protected DirectoryFieldEditor createDirectoryFieldEditor(String name, String label, Composite parent, FieldEditorDetails details) {
        DirectoryFieldEditor fieldEditor = new DirectoryFieldEditor(name, label, parent);
        if (details != null) {
            if (details.getTextLimit() != null) {
                fieldEditor.setTextLimit(details.getTextLimit().intValue());
            }
            if (details.getEmptyStringAllowed() != null) {
                fieldEditor.setEmptyStringAllowed(details.getEmptyStringAllowed().booleanValue());
            }
        }
        return fieldEditor;
    }

    protected DoubleComboFieldEditor createDoubleComboFieldEditor(String name, String label, Composite parent, FieldEditorDetails details) {
        DoubleComboFieldEditor fieldEditor = new DoubleComboFieldEditor(name, label, details.getLabelsAndValues().toArray(), parent);
        if (details.getEmptyStringAllowed() != null) {
            fieldEditor.setEmptyStringAllowed(details.getEmptyStringAllowed());
        }
        if (details.getNumberMinimum() != null) {
            fieldEditor.setMinValidValue(details.getNumberMinimum().doubleValue());
        }
        if (details.getNumberMaximum() != null) {
            fieldEditor.setMaxValidValue(details.getNumberMaximum().doubleValue());
        }
        if (details.getTextLimit() != null) {
            fieldEditor.setTextLimit(details.getTextLimit());
        }
        return fieldEditor;
    }

    protected EmailAddressesListEditor createEmailAddressesListEditor(String name, String label, Composite parent, FieldEditorDetails details) {
        if (details != null) {
            return new EmailAddressesListEditor(name, label, parent, details.getHorizontalSpan(), details.getIcons());
        }
        return new EmailAddressesListEditor(name, label, parent, null, new Image[0]);
    }

    protected FileFieldEditor createFileFieldEditor(String name, String label, Composite parent, FieldEditorDetails details) {
        FileFieldEditor fieldEditor = details != null && details.getFileEnforceAbsolute() != null ? new FileFieldEditor(name, label, details.getFileEnforceAbsolute().booleanValue(), parent) : new FileFieldEditor(name, label, parent);
        if (details != null) {
            if (details.getTextLimit() != null) {
                fieldEditor.setTextLimit(details.getTextLimit().intValue());
            }
            if (details.getEmptyStringAllowed() != null) {
                fieldEditor.setEmptyStringAllowed(details.getEmptyStringAllowed().booleanValue());
            }
            if (details.getFileExtensions() != null && details.getFileExtensions().length != 0) {
                fieldEditor.setFileExtensions(details.getFileExtensions());
            }
        }
        return fieldEditor;
    }

    protected FloatComboFieldEditor createFloatComboFieldEditor(String name, String label, Composite parent, FieldEditorDetails details) {
        FloatComboFieldEditor fieldEditor = new FloatComboFieldEditor(name, label, details.getLabelsAndValues().toArray(), parent);
        if (details.getEmptyStringAllowed() != null) {
            fieldEditor.setEmptyStringAllowed(details.getEmptyStringAllowed());
        }
        if (details.getNumberMinimum() != null) {
            fieldEditor.setMinValidValue(Float.valueOf(details.getNumberMinimum().floatValue()));
        }
        if (details.getNumberMaximum() != null) {
            fieldEditor.setMaxValidValue(Float.valueOf(details.getNumberMaximum().floatValue()));
        }
        if (details.getTextLimit() != null) {
            fieldEditor.setTextLimit(details.getTextLimit());
        }
        return fieldEditor;
    }

    protected FontFieldEditor createFontFieldEditor(String name, String label, Composite parent, FieldEditorDetails details) {
        FontFieldEditor fieldEditor = details != null && details.getFontPreviewAreaText() != null ? new FontFieldEditor(name, label, details.getFontPreviewAreaText().get(), parent) : new FontFieldEditor(name, label, parent);
        if (details != null && details.getFontChangeButtonText() != null) {
            fieldEditor.setChangeButtonText(details.getFontChangeButtonText().get());
        } else {
            fieldEditor.setChangeButtonText(JFaceMessages.get("lbl.button.change"));
        }
        return fieldEditor;
    }

    protected IntegerComboFieldEditor createIntegerComboFieldEditor(String name, String label, Composite parent, FieldEditorDetails details) {
        IntegerComboFieldEditor fieldEditor = new IntegerComboFieldEditor(name, label, details.getLabelsAndValues().toArray(), parent);
        if (details.getEmptyStringAllowed() != null) {
            fieldEditor.setEmptyStringAllowed(details.getEmptyStringAllowed());
        }
        if (details.getNumberMinimum() != null) {
            fieldEditor.setMinValidValue(details.getNumberMinimum().intValue());
        }
        if (details.getNumberMaximum() != null) {
            fieldEditor.setMaxValidValue(details.getNumberMaximum().intValue());
        }
        if (details.getTextLimit() != null) {
            fieldEditor.setTextLimit(details.getTextLimit());
        }
        return fieldEditor;
    }

    protected IntegerFieldEditor createIntegerFieldEditor(String name, String label, Composite parent, FieldEditorDetails details) {
        IntegerFieldEditor fieldEditor = new IntegerFieldEditor(name, label, parent);
        if (details != null) {
            if (details.getEmptyStringAllowed() != null) {
                fieldEditor.setEmptyStringAllowed(details.getEmptyStringAllowed().booleanValue());
            }
            if (details.getNumberMinimum() != null && details.getNumberMaximum() != null) {
                fieldEditor.setValidRange(details.getNumberMinimum().intValue(), details.getNumberMaximum().intValue());
                fieldEditor.setTextLimit(Math.max(Integer.toString(details.getNumberMaximum().intValue()).length(), Integer.toString(details.getNumberMinimum().intValue()).length()));
            }
            if (details.getTextLimit() != null) {
                fieldEditor.setTextLimit(details.getTextLimit().intValue());
            }
        }
        return fieldEditor;
    }

    protected LocalizedPathEditor createLocalizedPathEditor(String name, String label, Composite parent, FieldEditorDetails details) {
        LocalizedPathEditor fieldEditor = details != null ? new LocalizedPathEditor(name, label, details.getDirectoryDialogMessage(), parent, details.getHorizontalSpan()) : new LocalizedPathEditor(name, label, null, parent);
        return fieldEditor;
    }

    protected LongComboFieldEditor createLongComboFieldEditor(String name, String label, Composite parent, FieldEditorDetails details) {
        LongComboFieldEditor fieldEditor = new LongComboFieldEditor(name, label, details.getLabelsAndValues().toArray(), parent);
        if (details.getEmptyStringAllowed() != null) {
            fieldEditor.setEmptyStringAllowed(details.getEmptyStringAllowed());
        }
        if (details.getNumberMinimum() != null) {
            fieldEditor.setMinValidValue(details.getNumberMinimum().longValue());
        }
        if (details.getNumberMaximum() != null) {
            fieldEditor.setMaxValidValue(details.getNumberMaximum().longValue());
        }
        if (details.getTextLimit() != null) {
            fieldEditor.setTextLimit(details.getTextLimit());
        }
        return fieldEditor;
    }

    protected PasswordFieldEditor createPasswordFieldEditor(String name, String label, Composite parent, FieldEditorDetails details) {
        PasswordFieldEditor fieldEditor;
        if (details == null) {
            fieldEditor = new PasswordFieldEditor(name, label, parent);
        } else {
            try {
                fieldEditor = details.getTextWidth() != null ? new PasswordFieldEditor(name, label, details.getHashAlgorithm(), details.getTextWidth(), parent) : new PasswordFieldEditor(name, label, details.getHashAlgorithm(), parent);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalArgumentException(details.getHashAlgorithm(), e);
            }
            if (details.getEmptyStringAllowed() != null) {
                fieldEditor.setEmptyStringAllowed(details.getEmptyStringAllowed());
            }
            if (details.getTextLimit() != null) {
                fieldEditor.setTextLimit(details.getTextLimit());
            }
        }
        return fieldEditor;
    }

    protected RadioGroupFieldEditor createRadioGroupFieldEditor(String name, String label, Composite parent, FieldEditorDetails details) {
        if (details.getRadioUseGroup() != null) {
            return new RadioGroupFieldEditor(name, label, details.getRadioNumColumns().intValue(), details.getLabelsAndValues().toArray(), parent, details.getRadioUseGroup().booleanValue());
        }
        return new RadioGroupFieldEditor(name, label, details.getRadioNumColumns().intValue(), details.getLabelsAndValues().toArray(), parent);
    }

    protected ScaleFieldEditor createScaleFieldEditor(String name, String label, Composite parent, FieldEditorDetails details) {
        ScaleFieldEditor fieldEditor = new ScaleFieldEditor(name, label, parent);
        if (details != null) {
            if (details.getScaleMaximum() != null) {
                fieldEditor.setMaximum(details.getScaleMaximum().intValue());
            }
            if (details.getScaleMinimum() != null) {
                fieldEditor.setMinimum(details.getScaleMinimum().intValue());
            }
            if (details.getScaleIncrement() != null) {
                fieldEditor.setIncrement(details.getScaleIncrement().intValue());
            }
            if (details.getScalePageIncrement() != null) {
                fieldEditor.setPageIncrement(details.getScalePageIncrement().intValue());
            }
        }
        return fieldEditor;
    }

    protected ScaleIntegerFieldEditor createScaleIntegerFieldEditor(String name, String label, Composite parent, FieldEditorDetails details) {
        int min = 0;
        int max = 10;
        int increment = 1;
        int pageIncrement = 1;
        if (details != null) {
            if (details.getScaleMinimum() != null) {
                min = details.getScaleMinimum();
            }
            if (details.getScaleMaximum() != null) {
                max = details.getScaleMaximum();
            }
            if (details.getScaleIncrement() != null) {
                increment = details.getScaleIncrement();
            }
            if (details.getScalePageIncrement() != null) {
                pageIncrement = details.getScalePageIncrement();
            }
        }
        ScaleIntegerFieldEditor fieldEditor = new ScaleIntegerFieldEditor(name, label, parent, 0, max, increment, pageIncrement);
        fieldEditor.setMinimum(min);
        return fieldEditor;
    }

    protected ShortComboFieldEditor createShortComboFieldEditor(String name, String label, Composite parent, FieldEditorDetails details) {
        ShortComboFieldEditor fieldEditor = new ShortComboFieldEditor(name, label, details.getLabelsAndValues().toArray(), parent);
        if (details.getEmptyStringAllowed() != null) {
            fieldEditor.setEmptyStringAllowed(details.getEmptyStringAllowed());
        }
        if (details.getNumberMinimum() != null) {
            fieldEditor.setMinValidValue(details.getNumberMinimum().shortValue());
        }
        if (details.getNumberMaximum() != null) {
            fieldEditor.setMaxValidValue(details.getNumberMaximum().shortValue());
        }
        if (details.getTextLimit() != null) {
            fieldEditor.setTextLimit(details.getTextLimit());
        }
        return fieldEditor;
    }

    protected ShortFieldEditor createShortFieldEditor(String name, String label, Composite parent, FieldEditorDetails details) {
        ShortFieldEditor fieldEditor = new ShortFieldEditor(name, label, parent);
        if (details != null) {
            if (details.getEmptyStringAllowed() != null) {
                fieldEditor.setEmptyStringAllowed(details.getEmptyStringAllowed());
            }
            if (details.getNumberMinimum() != null) {
                fieldEditor.setMinValidValue(details.getNumberMinimum().shortValue());
            }
            if (details.getNumberMaximum() != null) {
                fieldEditor.setMaxValidValue(details.getNumberMaximum().shortValue());
            }
            if (details.getTextLimit() != null) {
                fieldEditor.setTextLimit(details.getTextLimit());
            }
        }
        return fieldEditor;
    }

    protected StringFieldEditor createStringFieldEditor(String name, String label, Composite parent, FieldEditorDetails details) {
        StringFieldEditor fieldEditor = details != null && details.getTextWidth() != null && details.getTextValidateStrategy() != null ? new StringFieldEditor(name, label, details.getTextWidth().intValue(), details.getTextValidateStrategy().intValue(), parent) : (details != null && details.getTextValidateStrategy() != null ? new StringFieldEditor(name, label, StringFieldEditor.UNLIMITED, details.getTextValidateStrategy().intValue(), parent) : (details != null && details.getTextWidth() != null ? new StringFieldEditor(name, label, details.getTextWidth().intValue(), parent) : new StringFieldEditor(name, label, parent)));
        if (details != null) {
            if (details.getEmptyStringAllowed() != null) {
                fieldEditor.setEmptyStringAllowed(details.getEmptyStringAllowed().booleanValue());
            }
            if (details.getTextLimit() != null) {
                fieldEditor.setTextLimit(details.getTextLimit().intValue());
            }
        }
        return fieldEditor;
    }

    protected UriListEditor createUriListEditor(String name, String label, Composite parent, FieldEditorDetails details) {
        if (details != null) {
            return new UriListEditor(name, label, parent, details.getHorizontalSpan(), details.getIcons());
        }
        return new UriListEditor(name, label, parent, null, new Image[0]);
    }

    protected ValidatedComboFieldEditor createValidatedComboFieldEditor(String name, String label, Composite parent, FieldEditorDetails details) {
        ValidatedComboFieldEditor fieldEditor = new ValidatedComboFieldEditor(name, label, details.getLabelsAndValues().toArray(), parent);
        if (details.getEmptyStringAllowed() != null) {
            fieldEditor.setEmptyStringAllowed(details.getEmptyStringAllowed());
        }
        return fieldEditor;
    }

    protected WrapStringFieldEditor createWrapStringFieldEditor(String name, String label, Composite parent, FieldEditorDetails details) {
        WrapStringFieldEditor fieldEditor = details != null && details.getHeight() != null ? new WrapStringFieldEditor(name, label, parent, details.getHeight()) : new WrapStringFieldEditor(name, label, parent);
        if (details != null && details.getTextLimit() != null) {
            fieldEditor.setTextLimit(details.getTextLimit());
        }
        if (details != null && details.getEmptyStringAllowed() != null) {
            fieldEditor.setEmptyStringAllowed(details.getEmptyStringAllowed());
        }
        return fieldEditor;
    }
}

