/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.preference;

import io.github.albertus82.jface.preference.LabelsAndValues;
import io.github.albertus82.util.ISupplier;
import java.util.ArrayList;
import java.util.List;

public class LocalizedLabelsAndValues
implements LabelsAndValues {
    private final List<LabelValue> entries;

    public LocalizedLabelsAndValues() {
        this.entries = new ArrayList<LabelValue>();
    }

    public LocalizedLabelsAndValues(int initialCapacity) {
        this.entries = new ArrayList<LabelValue>(initialCapacity);
    }

    public LocalizedLabelsAndValues(ISupplier<String> name, Object value) {
        this(1);
        this.add(name, value);
    }

    public void add(ISupplier<String> name, Object value) {
        this.entries.add(new LabelValue(name, String.valueOf(value)));
    }

    @Override
    public String[][] toArray() {
        String[][] options = new String[this.entries.size()][2];
        int index = 0;
        for (LabelValue entry : this.entries) {
            options[index][0] = (String)entry.key.get();
            options[index][1] = entry.value;
            ++index;
        }
        return options;
    }

    public String toString() {
        return this.entries.toString();
    }

    private class LabelValue {
        private final ISupplier<String> key;
        private final String value;

        private LabelValue(ISupplier<String> key, String value) {
            if (key == null) {
                throw new NullPointerException("key cannot be null");
            }
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return this.key.get() + "=" + this.value;
        }
    }
}

