/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.preference;

import io.github.albertus82.jface.preference.IPreference;
import io.github.albertus82.jface.preference.page.IPageDefinition;
import io.github.albertus82.util.ISupplier;
import io.github.albertus82.util.Localized;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.FontData;

public class PreferenceDetails {
    private IPageDefinition pageDefinition;
    private String name;
    private ISupplier<String> label;
    private String defaultValue;
    private IPreference parent;
    private boolean restartRequired;
    private boolean separate;

    protected PreferenceDetails() {
    }

    private PreferenceDetails(PreferenceDetailsBuilder builder) {
        this.pageDefinition = builder.pageDefinition;
        this.name = builder.name;
        this.label = builder.label;
        this.defaultValue = builder.defaultValue;
        this.parent = builder.parent;
        this.restartRequired = builder.restartRequired;
        this.separate = builder.separate;
    }

    public IPageDefinition getPageDefinition() {
        return this.pageDefinition;
    }

    public void setPageDefinition(IPageDefinition pageDefinition) {
        this.pageDefinition = pageDefinition;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ISupplier<String> getLabel() {
        return this.label;
    }

    public void setLabel(ISupplier<String> label) {
        this.label = label;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public IPreference getParent() {
        return this.parent;
    }

    public void setParent(IPreference parent) {
        this.parent = parent;
    }

    public boolean isRestartRequired() {
        return this.restartRequired;
    }

    public void setRestartRequired(boolean restartRequired) {
        this.restartRequired = restartRequired;
    }

    public boolean isSeparate() {
        return this.separate;
    }

    public void setSeparate(boolean separate) {
        this.separate = separate;
    }

    public String toString() {
        return "PreferenceDetails [pageDefinition=" + this.pageDefinition + ", name=" + this.name + ", label=" + this.label + ", defaultValue=" + this.defaultValue + ", parent=" + this.parent + ", restartRequired=" + this.restartRequired + ", separate=" + this.separate + "]";
    }

    public static class PreferenceDetailsBuilder {
        private final IPageDefinition pageDefinition;
        private String name;
        private ISupplier<String> label;
        private String defaultValue;
        private IPreference parent;
        private boolean restartRequired;
        private boolean separate;

        public PreferenceDetailsBuilder(IPageDefinition pageDefinition) {
            this.pageDefinition = pageDefinition;
        }

        public PreferenceDetailsBuilder name(String name) {
            this.name = name;
            return this;
        }

        public PreferenceDetailsBuilder label(ISupplier<String> label) {
            this.label = label;
            return this;
        }

        public PreferenceDetailsBuilder label(final String label) {
            this.label = new Localized(){

                @Override
                public String getString() {
                    return label;
                }
            };
            return this;
        }

        public PreferenceDetailsBuilder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public PreferenceDetailsBuilder defaultValue(boolean defaultValue) {
            this.defaultValue = Boolean.toString(defaultValue);
            return this;
        }

        public PreferenceDetailsBuilder defaultValue(byte defaultValue) {
            this.defaultValue = Byte.toString(defaultValue);
            return this;
        }

        public PreferenceDetailsBuilder defaultValue(short defaultValue) {
            this.defaultValue = Short.toString(defaultValue);
            return this;
        }

        public PreferenceDetailsBuilder defaultValue(char defaultValue) {
            this.defaultValue = Character.toString(defaultValue);
            return this;
        }

        public PreferenceDetailsBuilder defaultValue(int defaultValue) {
            this.defaultValue = Integer.toString(defaultValue);
            return this;
        }

        public PreferenceDetailsBuilder defaultValue(long defaultValue) {
            this.defaultValue = Long.toString(defaultValue);
            return this;
        }

        public PreferenceDetailsBuilder defaultValue(float defaultValue) {
            this.defaultValue = Float.toString(defaultValue);
            return this;
        }

        public PreferenceDetailsBuilder defaultValue(double defaultValue) {
            this.defaultValue = Double.toString(defaultValue);
            return this;
        }

        public PreferenceDetailsBuilder defaultValue(FontData[] defaultValue) {
            this.defaultValue = PreferenceConverter.getStoredRepresentation((FontData[])defaultValue);
            return this;
        }

        public PreferenceDetailsBuilder defaultValue(Object defaultValue) {
            this.defaultValue = String.valueOf(defaultValue);
            return this;
        }

        public PreferenceDetailsBuilder parent(IPreference parent) {
            this.parent = parent;
            return this;
        }

        private PreferenceDetailsBuilder restartRequired(boolean restartRequired) {
            this.restartRequired = restartRequired;
            return this;
        }

        public PreferenceDetailsBuilder restartRequired() {
            return this.restartRequired(true);
        }

        private PreferenceDetailsBuilder separate(boolean separate) {
            this.separate = separate;
            return this;
        }

        public PreferenceDetailsBuilder separate() {
            return this.separate(true);
        }

        public PreferenceDetails build() {
            return new PreferenceDetails(this);
        }
    }
}

