/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.preference;

import io.github.albertus82.jface.EnhancedErrorDialog;
import io.github.albertus82.jface.JFaceMessages;
import io.github.albertus82.jface.preference.ConfigurationNode;
import io.github.albertus82.jface.preference.ConfigurationStore;
import io.github.albertus82.jface.preference.EnhancedPreferenceDialog;
import io.github.albertus82.jface.preference.IPreference;
import io.github.albertus82.jface.preference.IPreferencesCallback;
import io.github.albertus82.jface.preference.page.IPageDefinition;
import io.github.albertus82.util.IOUtils;
import io.github.albertus82.util.logging.LoggerFactory;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class Preferences {
    private static final Logger log = LoggerFactory.getLogger(Preferences.class);
    private final IPreferencesCallback preferencesCallback;
    private final IPageDefinition[] pageDefinitions;
    private final IPreference[] preferenceItems;
    private final Image[] images;
    private final PreferenceManager preferenceManager;
    private final PreferenceStore preferenceStore;
    private String dialogTitle = JFaceMessages.get("lbl.preferences.title");
    private boolean restartRequired = false;

    public Preferences(IPageDefinition[] pageDefinitions, IPreference[] preferences, IPreferencesCallback preferencesCallback) {
        this(pageDefinitions, preferences, preferencesCallback, null);
    }

    public Preferences(IPageDefinition[] pageDefinitions, IPreference[] preferenceItems, IPreferencesCallback preferencesCallback, Image[] images) {
        this.preferencesCallback = preferencesCallback;
        this.pageDefinitions = pageDefinitions;
        this.preferenceItems = preferenceItems;
        this.images = images;
        this.preferenceManager = this.createPreferenceManager();
        this.preferenceStore = this.createPreferenceStore();
    }

    public int openDialog(Shell parentShell) throws IOException {
        return this.openDialog(parentShell, null);
    }

    public int openDialog(Shell parentShell, IPageDefinition selectedPage) throws IOException {
        File file = new File(this.preferencesCallback.getFileName());
        if (file.exists()) {
            this.loadConfigurationFile(file);
        }
        EnhancedPreferenceDialog preferenceDialog = new EnhancedPreferenceDialog(parentShell, this.preferenceManager, this.dialogTitle, this.images);
        preferenceDialog.setPreferenceStore((IPreferenceStore)this.preferenceStore);
        if (selectedPage != null) {
            preferenceDialog.setSelectedNode(selectedPage.getNodeId());
        }
        HashMap<String, String> configurationBackup = new HashMap<String, String>();
        for (IPreference preference : this.preferenceItems) {
            if (!preference.isRestartRequired()) continue;
            configurationBackup.put(preference.getName(), this.preferenceStore.getString(preference.getName()));
        }
        int returnCode = preferenceDialog.open();
        if (returnCode == 0) {
            try {
                this.preferencesCallback.reload();
            }
            catch (IOException ioe) {
                String message = JFaceMessages.get("err.preferences.reload");
                log.log(Level.WARNING, message, ioe);
                EnhancedErrorDialog.openError(parentShell, this.dialogTitle, message, 2, ioe, Display.getCurrent().getSystemImage(8));
            }
        }
        for (Map.Entry backedUpProperty : configurationBackup.entrySet()) {
            String oldValue = (String)backedUpProperty.getValue();
            String newValue = this.preferenceStore.getString((String)backedUpProperty.getKey());
            if (!(oldValue != null && newValue == null || oldValue == null && newValue != null) && (oldValue == null || oldValue.equals(newValue))) continue;
            this.restartRequired = true;
            break;
        }
        return returnCode;
    }

    private void loadConfigurationFile(File file) throws IOException {
        FileInputStream configurationInputStream = null;
        try {
            configurationInputStream = new FileInputStream(file);
            this.preferenceStore.load((InputStream)configurationInputStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(configurationInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)configurationInputStream);
    }

    protected PreferenceStore createPreferenceStore() {
        String fileName = this.preferencesCallback.getFileName();
        ConfigurationStore store = new ConfigurationStore(fileName);
        for (IPreference preference : this.preferenceItems) {
            if (preference.getDefaultValue() == null) continue;
            store.setDefault(preference.getName(), preference.getDefaultValue());
        }
        return store;
    }

    protected PreferenceManager createPreferenceManager() {
        PreferenceManager manager = new PreferenceManager();
        HashMap<IPageDefinition, ConfigurationNode> preferenceNodes = new HashMap<IPageDefinition, ConfigurationNode>();
        for (IPageDefinition page : this.pageDefinitions) {
            ConfigurationNode preferenceNode = new ConfigurationNode(page, this.preferenceItems, this.preferencesCallback);
            if (page.getParent() != null) {
                ((PreferenceNode)preferenceNodes.get(page.getParent())).add((IPreferenceNode)preferenceNode);
            } else {
                manager.addToRoot((IPreferenceNode)preferenceNode);
            }
            preferenceNodes.put(page, preferenceNode);
        }
        return manager;
    }

    public String getDialogTitle() {
        return this.dialogTitle;
    }

    public void setDialogTitle(String dialogTitle) {
        this.dialogTitle = dialogTitle;
    }

    public boolean isRestartRequired() {
        return this.restartRequired;
    }

    public void setRestartRequired(boolean restartRequired) {
        this.restartRequired = restartRequired;
    }

    protected IPreferencesCallback getPreferencesCallback() {
        return this.preferencesCallback;
    }

    protected IPageDefinition[] getPageDefinitions() {
        return this.pageDefinitions;
    }

    protected IPreference[] getPreferences() {
        return this.preferenceItems;
    }

    protected Image[] getImages() {
        return this.images;
    }

    protected PreferenceManager getPreferenceManager() {
        return this.preferenceManager;
    }

    protected PreferenceStore getPreferenceStore() {
        return this.preferenceStore;
    }
}

