/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.preference.field;

import io.github.albertus82.jface.JFaceMessages;
import io.github.albertus82.util.logging.LoggerFactory;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

abstract class AbstractDateFieldEditor
extends StringFieldEditor {
    private static final Logger log = LoggerFactory.getLogger(AbstractDateFieldEditor.class);
    protected final ThreadLocal<DateFormat> dateFormats = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat df = new SimpleDateFormat(AbstractDateFieldEditor.this.pattern);
            df.setLenient(false);
            return df;
        }
    };
    private Composite parent;
    private String pattern;
    private int style;
    private DateTime dateTime;
    private Date minValidValue;
    private Date maxValidValue;
    private int validateStrategy;
    private ControlDecoration controlDecorator;

    protected AbstractDateFieldEditor(String name, String labelText, String pattern, int style, Composite parent) {
        super(name, labelText, parent);
        this.init(pattern, style, 0, parent);
    }

    protected AbstractDateFieldEditor(String name, String labelText, String pattern, int style, int width, Composite parent) {
        super(name, labelText, width, parent);
        this.init(pattern, style, 0, parent);
    }

    protected AbstractDateFieldEditor(String name, String labelText, String pattern, int style, int width, int strategy, Composite parent) {
        super(name, labelText, width, strategy, parent);
        this.init(pattern, style, strategy, parent);
    }

    protected void createControl(Composite parent) {
    }

    protected void valueChanged() {
        if (this.dateTime == null) {
            super.valueChanged();
        } else {
            this.setPresentsDefaultValue(false);
            boolean oldState = this.isValid();
            this.refreshValidState();
            if (this.isValid() != oldState) {
                this.fireStateChanged("field_editor_is_valid", oldState, this.isValid());
            }
            try {
                String newValue = this.dateFormats.get().format(this.getDateValue());
                if (!newValue.equals(this.oldValue)) {
                    this.fireValueChanged("field_editor_value", this.oldValue, newValue);
                    this.oldValue = newValue;
                }
            }
            catch (ParseException pe) {
                log.log(Level.SEVERE, JFaceMessages.get("err.date.parse"), pe);
            }
        }
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        if (this.style == 0) {
            super.doFillIntoGrid(parent, numColumns);
            this.addDecoration();
        } else {
            this.getLabelControl(parent);
            if (this.dateTime == null) {
                this.dateTime = this.getDateTimeControl(parent);
            }
            GridData gd = new GridData();
            gd.horizontalSpan = numColumns - 1;
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.dateTime.setLayoutData((Object)gd);
        }
    }

    public Text getTextControl(Composite parent) {
        if (this.style == 0) {
            return super.getTextControl(parent);
        }
        throw new IllegalStateException("style is " + this.style);
    }

    public DateTime getDateTimeControl(Composite parent) {
        if (this.dateTime != null) {
            return this.dateTime;
        }
        if (this.style == 0) {
            throw new IllegalStateException("style is " + this.style);
        }
        DateTime dt = new DateTime(parent, this.style);
        switch (this.validateStrategy) {
            case 0: {
                dt.addKeyListener((KeyListener)new KeyAdapter(){

                    public void keyReleased(KeyEvent e) {
                        AbstractDateFieldEditor.this.valueChanged();
                    }
                });
                dt.addFocusListener((FocusListener)new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        AbstractDateFieldEditor.this.valueChanged();
                    }
                });
                break;
            }
            case 1: {
                dt.addKeyListener((KeyListener)new KeyAdapter(){

                    public void keyPressed(KeyEvent e) {
                        AbstractDateFieldEditor.this.clearErrorMessage();
                    }
                });
                dt.addFocusListener((FocusListener)new FocusAdapter(){

                    public void focusGained(FocusEvent e) {
                        AbstractDateFieldEditor.this.refreshValidState();
                    }

                    public void focusLost(FocusEvent e) {
                        AbstractDateFieldEditor.this.valueChanged();
                        AbstractDateFieldEditor.this.clearErrorMessage();
                    }
                });
                break;
            }
            default: {
                Assert.isTrue((boolean)false, (String)"Unknown validate strategy");
            }
        }
        return dt;
    }

    protected void adjustForNumColumns(int numColumns) {
        GridData gd = this.style == 0 ? (GridData)this.getTextControl().getLayoutData() : (GridData)this.getDateTimeControl().getLayoutData();
        if (gd != null) {
            gd.horizontalSpan = numColumns - 1;
            gd.grabExcessHorizontalSpace = gd.horizontalSpan == 1;
        } else {
            log.warning("layoutData is null");
        }
    }

    protected boolean checkState() {
        if (this.dateTime == null) {
            return super.checkState();
        }
        boolean result = this.doCheckState();
        if (result) {
            this.clearErrorMessage();
        } else {
            this.showErrorMessage(this.getErrorMessage());
        }
        return result;
    }

    protected boolean doCheckState() {
        boolean result;
        Date date = null;
        if (this.isEmptyStringAllowed() && this.getTextControl() != null && this.getTextControl().getText().isEmpty()) {
            result = true;
        } else {
            try {
                date = this.getDateValue();
                result = true;
            }
            catch (ParseException pe) {
                result = false;
            }
        }
        if (date != null && (this.getMinValidValue() != null && date.before(this.getMinValidValue()) || this.getMaxValidValue() != null && date.after(this.getMaxValidValue()))) {
            result = false;
        }
        return result;
    }

    protected void doLoad() {
        if (this.dateTime == null) {
            Text textField = this.getTextControl();
            if (textField != null) {
                String value = this.getPreferenceStore().getString(this.getPreferenceName());
                try {
                    DateFormat df = this.dateFormats.get();
                    value = df.format(df.parse(value));
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                textField.setText(value);
                this.oldValue = value;
            }
        } else {
            String value = this.getPreferenceStore().getString(this.getPreferenceName());
            Calendar calendar = Calendar.getInstance();
            try {
                calendar.setTime(this.dateFormats.get().parse(value));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            this.setDateTimeValue(calendar);
            this.oldValue = value;
        }
    }

    protected void doLoadDefault() {
        if (this.dateTime == null) {
            super.doLoadDefault();
            this.getTextControl().notifyListeners(2, null);
        } else {
            String value = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            Calendar calendar = Calendar.getInstance();
            try {
                calendar.setTime(this.dateFormats.get().parse(value));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            this.setDateTimeValue(calendar);
            this.valueChanged();
        }
    }

    protected void doStore() {
        if (this.dateTime == null) {
            super.doStore();
        } else {
            try {
                Date date = this.getDateValue();
                String dateString = this.dateFormats.get().format(date);
                this.getPreferenceStore().setValue(this.getPreferenceName(), dateString);
            }
            catch (ParseException pe) {
                log.log(Level.SEVERE, JFaceMessages.get("err.date.parse"), pe);
            }
        }
    }

    protected void setDateTimeValue(Calendar calendar) {
        this.dateTime.setDate(calendar.get(1), calendar.get(2), calendar.get(5));
        this.dateTime.setTime(calendar.get(11), calendar.get(12), calendar.get(13));
    }

    protected void setDateTimeValue(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setLenient(false);
        calendar.setTime(date);
        this.setDateTimeValue(calendar);
    }

    public void setValidRange(Date from, Date to) {
        this.setMinValidValue(from);
        this.setMaxValidValue(to);
    }

    protected void checkPattern(String pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern cannot be null");
        }
    }

    protected void init(String pattern, int style, int validateStrategy, Composite parent) {
        this.checkPattern(pattern);
        this.pattern = pattern;
        this.parent = parent;
        this.style = style;
        this.validateStrategy = validateStrategy;
        this.updateErrorMessage();
        this.setTextLimit(127);
        this.doCreateControl();
    }

    protected void doCreateControl() {
        GridLayout layout = new GridLayout();
        layout.numColumns = this.getNumberOfControls();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 8;
        this.parent.setLayout((Layout)layout);
        this.doFillIntoGrid(this.parent, layout.numColumns);
        this.getLabelControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AbstractDateFieldEditor.this.dateFormats.remove();
            }
        });
    }

    protected void addDecoration() {
        this.controlDecorator = new ControlDecoration((Control)this.getTextControl(), 16512);
        this.controlDecorator.hide();
        Image image = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
        this.controlDecorator.setImage(image);
    }

    protected void showErrorMessage(String msg) {
        super.showErrorMessage(msg);
        if (this.controlDecorator != null) {
            this.controlDecorator.setDescriptionText(msg);
            this.controlDecorator.show();
        }
    }

    protected void clearErrorMessage() {
        super.clearErrorMessage();
        if (this.controlDecorator != null) {
            this.controlDecorator.hide();
        }
    }

    public DateTime getDateTimeControl() {
        return this.dateTime;
    }

    public String getPattern() {
        return this.pattern;
    }

    public int getStyle() {
        return this.style;
    }

    public Date getDateValue() throws ParseException {
        if (this.dateTime == null) {
            return this.dateFormats.get().parse(this.getTextControl().getText());
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setLenient(false);
        calendar.set(this.dateTime.getYear(), this.dateTime.getMonth(), this.dateTime.getDay(), this.dateTime.getHours(), this.dateTime.getMinutes(), this.dateTime.getSeconds());
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public Date getMinValidValue() {
        return this.minValidValue;
    }

    public void setMinValidValue(Date minValidValue) {
        this.minValidValue = minValidValue;
        this.updateErrorMessage();
    }

    public Date getMaxValidValue() {
        return this.maxValidValue;
    }

    public void setMaxValidValue(Date maxValidValue) {
        this.maxValidValue = maxValidValue;
        this.updateErrorMessage();
    }

    public int getValidateStrategy() {
        return this.validateStrategy;
    }

    public void setValidateStrategy(int value) {
        super.setValidateStrategy(value);
        this.validateStrategy = value;
    }

    protected void updateErrorMessage() {
        if (this.getMinValidValue() == null && this.getMaxValidValue() == null) {
            this.setErrorMessage(JFaceMessages.get("err.preferences.date", this.pattern));
        } else {
            DateFormat df = this.dateFormats.get();
            if (this.getMinValidValue() != null && this.getMaxValidValue() == null) {
                this.setErrorMessage(JFaceMessages.get("err.preferences.date.from", df.format(this.getMinValidValue())));
            } else if (this.getMinValidValue() == null && this.getMaxValidValue() != null) {
                this.setErrorMessage(JFaceMessages.get("err.preferences.date.to", df.format(this.getMaxValidValue())));
            } else {
                this.setErrorMessage(JFaceMessages.get("err.preferences.date.range", df.format(this.getMinValidValue()), df.format(this.getMaxValidValue())));
            }
        }
    }

    public void setEnabled(boolean enabled, Composite parent) {
        if (this.style == 0) {
            super.setEnabled(enabled, parent);
        } else {
            this.getLabelControl(parent).setEnabled(enabled);
            this.getDateTimeControl(parent).setEnabled(enabled);
        }
    }
}

