/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.preference.field;

import io.github.albertus82.jface.JFaceMessages;
import io.github.albertus82.jface.preference.field.AbstractNumberComboFieldEditor;
import org.eclipse.swt.widgets.Composite;

abstract class AbstractIntegerComboFieldEditor<T extends Number>
extends AbstractNumberComboFieldEditor<T> {
    protected AbstractIntegerComboFieldEditor(String name, String labelText, String[][] entryNamesAndValues, Composite parent) {
        super(name, labelText, entryNamesAndValues, parent);
    }

    @Override
    protected void updateTextLimit() {
        int maxNumberLength = this.getDefaultTextLimit();
        if (this.getMinValidValue() != null && this.getMaxValidValue() != null) {
            maxNumberLength = Math.max(this.getMinValidValue().toString().length(), this.getMaxValidValue().toString().length());
        }
        this.setTextLimit(Math.max(maxNumberLength, this.getMaxLabelLength()));
    }

    @Override
    protected void updateErrorMessage() {
        if (this.getMinValidValue() == null && this.getMaxValidValue() == null) {
            this.setErrorMessage(JFaceMessages.get("err.preferences.integer"));
        } else if (this.getMinValidValue() != null && this.getMaxValidValue() == null) {
            this.setErrorMessage(JFaceMessages.get("err.preferences.integer.min", this.getMinValidValue()));
        } else if (this.getMinValidValue() == null && this.getMaxValidValue() != null) {
            this.setErrorMessage(JFaceMessages.get("err.preferences.integer.max", this.getMaxValidValue()));
        } else {
            this.setErrorMessage(JFaceMessages.get("err.preferences.integer.range", this.getMinValidValue(), this.getMaxValidValue()));
        }
    }
}

