/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.preference.field;

import io.github.albertus82.jface.listener.LowerCaseVerifyListener;
import io.github.albertus82.jface.listener.TrimVerifyListener;
import io.github.albertus82.jface.listener.UpperCaseVerifyListener;
import io.github.albertus82.jface.preference.field.ValidatedComboFieldEditor;
import io.github.albertus82.util.logging.LoggerFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;

abstract class AbstractNumberComboFieldEditor<T extends Number>
extends ValidatedComboFieldEditor {
    private static final Logger log = LoggerFactory.getLogger(AbstractNumberComboFieldEditor.class);
    protected final LabelsCase labelsCase;
    private T minValidValue;
    private T maxValidValue;

    protected AbstractNumberComboFieldEditor(String name, String labelText, String[][] entryNamesAndValues, Composite parent) {
        super(name, labelText, entryNamesAndValues, parent);
        this.setEmptyStringAllowed(false);
        this.labelsCase = this.getLabelsCase();
        if (LabelsCase.UPPER.equals((Object)this.labelsCase)) {
            this.getComboBoxControl().addVerifyListener((VerifyListener)new UpperCaseVerifyListener());
        } else if (LabelsCase.LOWER.equals((Object)this.labelsCase)) {
            this.getComboBoxControl().addVerifyListener((VerifyListener)new LowerCaseVerifyListener());
        }
        if (!this.labelsContainWhitespace()) {
            this.getComboBoxControl().addVerifyListener((VerifyListener)new TrimVerifyListener());
        }
        this.setTextLimit(Math.max(this.getMaxLabelLength(), this.getDefaultTextLimit()));
        this.updateErrorMessage();
    }

    @Override
    protected String getDefaultValue() {
        return this.cleanValue(super.getDefaultValue());
    }

    @Override
    protected boolean doCheckState() {
        try {
            return this.checkValidRange(this.getNumberValue());
        }
        catch (NumberFormatException e) {
            log.log(Level.FINEST, "The value provided is not a valid representation of a number:", e);
            return false;
        }
    }

    protected int getDefaultTextLimit() {
        return 8192;
    }

    protected boolean checkValidRange(Comparable<T> number) {
        return !(this.getMinValidValue() != null && number.compareTo(this.getMinValidValue()) < 0 || this.getMaxValidValue() != null && number.compareTo(this.getMaxValidValue()) > 0);
    }

    public void setValidRange(T min, T max) {
        this.setMinValidValue(min);
        this.setMaxValidValue(max);
    }

    public T getMinValidValue() {
        return this.minValidValue;
    }

    public void setMinValidValue(T min) {
        this.minValidValue = min;
        this.updateErrorMessage();
        this.updateTextLimit();
    }

    public T getMaxValidValue() {
        return this.maxValidValue;
    }

    public void setMaxValidValue(T max) {
        this.maxValidValue = max;
        this.updateErrorMessage();
        this.updateTextLimit();
    }

    protected boolean labelsContainWhitespace() {
        for (String[] entry : this.getEntryNamesAndValues()) {
            if (!entry[0].contains(" ")) continue;
            return true;
        }
        return false;
    }

    protected LabelsCase getLabelsCase() {
        int upperCaseCount = 0;
        int lowerCaseCount = 0;
        for (String[] entry : this.getEntryNamesAndValues()) {
            if (entry[0].equals(entry[0].toLowerCase())) {
                ++lowerCaseCount;
                continue;
            }
            if (!entry[0].equals(entry[0].toUpperCase())) continue;
            ++upperCaseCount;
        }
        if (upperCaseCount == this.getEntryNamesAndValues().length) {
            return LabelsCase.UPPER;
        }
        if (lowerCaseCount == this.getEntryNamesAndValues().length) {
            return LabelsCase.LOWER;
        }
        return LabelsCase.MIXED;
    }

    public abstract Comparable<T> getNumberValue();

    protected abstract void updateTextLimit();

    protected abstract void updateErrorMessage();

    protected static enum LabelsCase {
        UPPER,
        LOWER,
        MIXED;

    }
}

