/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.preference.field;

import io.github.albertus82.jface.preference.field.EnhancedStringFieldEditor;
import io.github.albertus82.util.logging.LoggerFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Composite;

abstract class AbstractNumberFieldEditor<T extends Number>
extends EnhancedStringFieldEditor {
    private static final Logger log = LoggerFactory.getLogger(AbstractNumberFieldEditor.class);
    private T minValidValue;
    private T maxValidValue;

    protected AbstractNumberFieldEditor(String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.setEmptyStringAllowed(false);
        this.setTextLimit(this.getDefaultTextLimit());
        this.createControl(parent);
        this.updateErrorMessage();
        this.addDecoration();
    }

    protected int getDefaultTextLimit() {
        return 8192;
    }

    @Override
    protected boolean doCheckState() {
        try {
            return this.checkValidRange(this.getNumberValue());
        }
        catch (NumberFormatException e) {
            log.log(Level.FINEST, "The value provided is not a valid representation of a number:", e);
            return false;
        }
    }

    protected boolean checkValidRange(Comparable<T> number) {
        return !(this.getMinValidValue() != null && number.compareTo(this.getMinValidValue()) < 0 || this.getMaxValidValue() != null && number.compareTo(this.getMaxValidValue()) > 0);
    }

    public void setValidRange(T min, T max) {
        this.setMinValidValue(min);
        this.setMaxValidValue(max);
    }

    public T getMinValidValue() {
        return this.minValidValue;
    }

    public void setMinValidValue(T min) {
        this.minValidValue = min;
        this.updateErrorMessage();
        this.updateTextLimit();
    }

    public T getMaxValidValue() {
        return this.maxValidValue;
    }

    public void setMaxValidValue(T max) {
        this.maxValidValue = max;
        this.updateErrorMessage();
        this.updateTextLimit();
    }

    public abstract Comparable<T> getNumberValue();

    protected abstract void updateTextLimit();

    protected abstract void updateErrorMessage();
}

