/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.preference.field;

import io.github.albertus82.jface.listener.BigDecimalVerifyListener;
import io.github.albertus82.jface.preference.field.AbstractDecimalFieldEditor;
import io.github.albertus82.util.ISupplier;
import io.github.albertus82.util.Supplier;
import io.github.albertus82.util.logging.LoggerFactory;
import java.math.BigDecimal;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class BigDecimalFieldEditor
extends AbstractDecimalFieldEditor<BigDecimal> {
    private static final Logger log = LoggerFactory.getLogger(BigDecimalFieldEditor.class);

    public BigDecimalFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
        this.getTextControl().addVerifyListener((VerifyListener)new BigDecimalVerifyListener((ISupplier<Boolean>)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return BigDecimalFieldEditor.this.getMinValidValue() == null || ((BigDecimal)BigDecimalFieldEditor.this.getMinValidValue()).compareTo(BigDecimal.ZERO) < 0;
            }
        }));
        this.getTextControl().addFocusListener((FocusListener)new BigDecimalFocusListener());
    }

    @Override
    protected void doLoad() {
        super.doLoad();
        Text text = this.getTextControl();
        if (text != null) {
            String value;
            try {
                value = new BigDecimal(this.getPreferenceStore().getString(this.getPreferenceName()).trim()).toString();
            }
            catch (NumberFormatException e) {
                log.log(Level.FINEST, "The value provided is not a valid representation of a BigDecimal:", e);
                value = "";
            }
            text.setText(value);
            this.oldValue = value;
        }
        this.updateFontStyle();
    }

    protected void doStore() {
        Text text = this.getTextControl();
        if (text != null) {
            if (text.getText().isEmpty() && this.isEmptyStringAllowed()) {
                this.getPreferenceStore().setValue(this.getPreferenceName(), "");
            } else {
                BigDecimal value = new BigDecimal(text.getText());
                this.getPreferenceStore().setValue(this.getPreferenceName(), value.toString());
            }
        }
    }

    @Override
    protected String getDefaultValue() {
        String defaultValue = super.getDefaultValue();
        try {
            return new BigDecimal(defaultValue).toString();
        }
        catch (NumberFormatException e) {
            log.log(Level.FINEST, "The value provided is not a valid representation of a BigDecimal:", e);
            return "";
        }
    }

    public BigDecimal getNumberValue() {
        return new BigDecimal(this.getStringValue());
    }

    protected class BigDecimalFocusListener
    extends FocusAdapter {
        protected BigDecimalFocusListener() {
        }

        public void focusLost(FocusEvent fe) {
            Text text = (Text)fe.widget;
            String oldText = text.getText();
            try {
                String newText = new BigDecimal(oldText).toString();
                if (!oldText.equals(newText)) {
                    text.setText(newText);
                }
                BigDecimalFieldEditor.this.valueChanged();
            }
            catch (Exception e) {
                log.log(Level.FINE, "Cannot change the value of the field:", e);
            }
        }
    }
}

