/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.preference.field;

import io.github.albertus82.jface.preference.field.AbstractIntegerComboFieldEditor;
import io.github.albertus82.util.logging.LoggerFactory;
import java.math.BigInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Composite;

public class BigIntegerComboFieldEditor
extends AbstractIntegerComboFieldEditor<BigInteger> {
    private static final Logger log = LoggerFactory.getLogger(BigIntegerComboFieldEditor.class);

    public BigIntegerComboFieldEditor(String name, String labelText, String[][] entryNamesAndValues, Composite parent) {
        super(name, labelText, entryNamesAndValues, parent);
    }

    @Override
    protected String cleanValue(String value) {
        String cleanValue = super.cleanValue(value);
        try {
            return new BigInteger(cleanValue).toString();
        }
        catch (NumberFormatException e) {
            log.log(Level.FINEST, "The value provided is not a valid representation of a BigInteger:", e);
            return cleanValue;
        }
    }

    @Override
    protected void cleanComboText() {
        String oldText = this.getComboBoxControl().getText();
        String newText = oldText.trim();
        try {
            newText = this.getNameForValue(new BigInteger(newText).toString());
        }
        catch (Exception e) {
            log.log(Level.FINEST, "Cannot determine a name for the value provided:", e);
        }
        if (!newText.equals(oldText)) {
            this.getComboBoxControl().setText(newText);
        }
    }

    @Override
    public String getValue() {
        try {
            return new BigInteger(super.getValue()).toString();
        }
        catch (Exception e) {
            log.log(Level.FINEST, "Cannot translate the string into a BigInteger:", e);
            return super.getValue();
        }
    }

    @Override
    protected void setValue(String value) {
        try {
            super.setValue(new BigInteger(value).toString());
        }
        catch (Exception e) {
            log.log(Level.FINEST, "Cannot translate the string into a BigInteger:", e);
            super.setValue(value);
        }
    }

    @Override
    protected String getNameForValue(String value) {
        for (String[] entry : this.getEntryNamesAndValues()) {
            String comboValue;
            try {
                comboValue = new BigInteger(entry[1]).toString();
            }
            catch (Exception e) {
                log.log(Level.FINE, "Cannot translate the string into a BigInteger:", e);
                comboValue = entry[1];
            }
            if (!value.equals(comboValue)) continue;
            return entry[0];
        }
        return value;
    }

    public BigInteger getNumberValue() {
        return new BigInteger(this.getValue());
    }
}

