/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.preference.field;

import io.github.albertus82.jface.listener.BigIntegerVerifyListener;
import io.github.albertus82.jface.preference.field.AbstractIntegerFieldEditor;
import io.github.albertus82.util.ISupplier;
import io.github.albertus82.util.Supplier;
import io.github.albertus82.util.logging.LoggerFactory;
import java.math.BigInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class BigIntegerFieldEditor
extends AbstractIntegerFieldEditor<BigInteger> {
    private static final Logger log = LoggerFactory.getLogger(BigIntegerFieldEditor.class);

    public BigIntegerFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
        this.getTextControl().addVerifyListener((VerifyListener)new BigIntegerVerifyListener((ISupplier<Boolean>)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return BigIntegerFieldEditor.this.getMinValidValue() == null || ((BigInteger)BigIntegerFieldEditor.this.getMinValidValue()).intValue() < 0;
            }
        }));
        this.getTextControl().addFocusListener((FocusListener)new BigIntegerFocusListener());
    }

    @Override
    protected void doLoad() {
        super.doLoad();
        Text text = this.getTextControl();
        if (text != null) {
            String value;
            try {
                value = new BigInteger(this.getPreferenceStore().getString(this.getPreferenceName()).trim()).toString();
            }
            catch (NumberFormatException e) {
                log.log(Level.FINEST, "The value provided is not a valid representation of a BigInteger:", e);
                value = "";
            }
            text.setText(value);
            this.oldValue = value;
        }
        this.updateFontStyle();
    }

    protected void doStore() {
        Text text = this.getTextControl();
        if (text != null) {
            if (text.getText().isEmpty() && this.isEmptyStringAllowed()) {
                this.getPreferenceStore().setValue(this.getPreferenceName(), "");
            } else {
                BigInteger value = new BigInteger(text.getText());
                this.getPreferenceStore().setValue(this.getPreferenceName(), value.toString());
            }
        }
    }

    @Override
    protected String getDefaultValue() {
        String defaultValue = super.getDefaultValue();
        try {
            return new BigInteger(defaultValue).toString();
        }
        catch (NumberFormatException e) {
            log.log(Level.FINEST, "The value provided is not a valid representation of a BigInteger:", e);
            return "";
        }
    }

    public BigInteger getNumberValue() {
        return new BigInteger(this.getStringValue());
    }

    protected class BigIntegerFocusListener
    extends FocusAdapter {
        protected BigIntegerFocusListener() {
        }

        public void focusLost(FocusEvent fe) {
            Text text = (Text)fe.widget;
            String oldText = text.getText();
            try {
                String newText = new BigInteger(oldText).toString();
                if (!oldText.equals(newText)) {
                    text.setText(newText);
                }
                BigIntegerFieldEditor.this.valueChanged();
            }
            catch (Exception e) {
                log.log(Level.FINE, "Cannot change the value of the field:", e);
            }
        }
    }
}

