/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.preference.field;

import io.github.albertus82.jface.preference.field.AbstractIntegerComboFieldEditor;
import io.github.albertus82.util.logging.LoggerFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Composite;

public class ByteComboFieldEditor
extends AbstractIntegerComboFieldEditor<Byte> {
    private static final Logger log = LoggerFactory.getLogger(ByteComboFieldEditor.class);
    private static final int DEFAULT_TEXT_LIMIT = Byte.toString((byte)127).length();

    public ByteComboFieldEditor(String name, String labelText, String[][] entryNamesAndValues, Composite parent) {
        super(name, labelText, entryNamesAndValues, parent);
        this.setMinValidValue((byte)0);
        this.setMaxValidValue((byte)127);
    }

    @Override
    protected int getDefaultTextLimit() {
        return DEFAULT_TEXT_LIMIT;
    }

    @Override
    protected String cleanValue(String value) {
        String cleanValue = super.cleanValue(value);
        try {
            return Byte.valueOf(cleanValue).toString();
        }
        catch (NumberFormatException e) {
            log.log(Level.FINEST, "The value provided does not contain a parsable byte:", e);
            return cleanValue;
        }
    }

    @Override
    protected void cleanComboText() {
        String oldText = this.getComboBoxControl().getText();
        String newText = oldText.trim();
        try {
            newText = this.getNameForValue(Byte.valueOf(newText).toString());
        }
        catch (Exception e) {
            log.log(Level.FINEST, "Cannot determine a name for the value provided:", e);
        }
        if (!newText.equals(oldText)) {
            this.getComboBoxControl().setText(newText);
        }
    }

    @Override
    public String getValue() {
        try {
            return Byte.valueOf(super.getValue()).toString();
        }
        catch (Exception e) {
            log.log(Level.FINEST, "Cannot translate the string into a Byte:", e);
            return super.getValue();
        }
    }

    @Override
    protected void setValue(String value) {
        try {
            super.setValue(Byte.valueOf(value).toString());
        }
        catch (Exception e) {
            log.log(Level.FINEST, "Cannot translate the string into a Byte:", e);
            super.setValue(value);
        }
    }

    public Byte getNumberValue() {
        return Byte.valueOf(this.getValue());
    }
}

