/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.preference.field;

import io.github.albertus82.jface.listener.ByteVerifyListener;
import io.github.albertus82.jface.preference.field.AbstractIntegerFieldEditor;
import io.github.albertus82.util.ISupplier;
import io.github.albertus82.util.Supplier;
import io.github.albertus82.util.logging.LoggerFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class ByteFieldEditor
extends AbstractIntegerFieldEditor<Byte> {
    private static final Logger log = LoggerFactory.getLogger(ByteFieldEditor.class);
    private static final int DEFAULT_TEXT_LIMIT = Byte.toString((byte)127).length();

    public ByteFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
        this.setMinValidValue((byte)0);
        this.setMaxValidValue((byte)127);
        this.getTextControl().addVerifyListener((VerifyListener)new ByteVerifyListener((ISupplier<Boolean>)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return ByteFieldEditor.this.getMinValidValue() == null || (Byte)ByteFieldEditor.this.getMinValidValue() < 0;
            }
        }));
        this.getTextControl().addFocusListener((FocusListener)new ByteFocusListener());
    }

    @Override
    protected int getDefaultTextLimit() {
        return DEFAULT_TEXT_LIMIT;
    }

    @Override
    protected void doLoad() {
        super.doLoad();
        Text text = this.getTextControl();
        if (text != null) {
            String value;
            try {
                value = Byte.valueOf(this.getPreferenceStore().getString(this.getPreferenceName()).trim()).toString();
            }
            catch (NumberFormatException e) {
                log.log(Level.FINEST, "The value provided does not contain a parsable byte:", e);
                value = "";
            }
            text.setText(value);
            this.oldValue = value;
        }
        this.updateFontStyle();
    }

    protected void doStore() {
        Text text = this.getTextControl();
        if (text != null) {
            if (text.getText().isEmpty() && this.isEmptyStringAllowed()) {
                this.getPreferenceStore().setValue(this.getPreferenceName(), "");
            } else {
                Byte value = Byte.valueOf(text.getText());
                this.getPreferenceStore().setValue(this.getPreferenceName(), value.toString());
            }
        }
    }

    @Override
    protected String getDefaultValue() {
        String defaultValue = super.getDefaultValue();
        try {
            return Byte.valueOf(defaultValue).toString();
        }
        catch (NumberFormatException e) {
            log.log(Level.FINEST, "The value provided does not contain a parsable byte:", e);
            return "";
        }
    }

    public Byte getNumberValue() {
        return Byte.valueOf(this.getStringValue());
    }

    protected class ByteFocusListener
    extends FocusAdapter {
        protected ByteFocusListener() {
        }

        public void focusLost(FocusEvent fe) {
            Text text = (Text)fe.widget;
            String oldText = text.getText();
            try {
                String newText = Byte.toString(Byte.parseByte(oldText));
                if (!oldText.equals(newText)) {
                    text.setText(newText);
                }
                ByteFieldEditor.this.valueChanged();
            }
            catch (Exception e) {
                log.log(Level.FINE, "Cannot change the value of the field:", e);
            }
        }
    }
}

