/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.preference.field;

import io.github.albertus82.jface.Formatter;
import io.github.albertus82.jface.JFaceMessages;
import io.github.albertus82.jface.preference.field.AbstractDateFieldEditor;
import io.github.albertus82.jface.preference.field.FieldEditorDefault;
import io.github.albertus82.util.logging.LoggerFactory;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class DateFieldEditor
extends AbstractDateFieldEditor
implements FieldEditorDefault {
    private static final Logger log = LoggerFactory.getLogger(DateFieldEditor.class);
    private static final Formatter formatter = new Formatter(DateFieldEditor.class);
    private boolean defaultToolTip = true;
    private boolean boldCustomValues = true;

    public DateFieldEditor(String name, String labelText, String pattern, int style, Composite parent) {
        super(name, labelText, pattern, style, parent);
    }

    public DateFieldEditor(String name, String labelText, String pattern, int style, int width, Composite parent) {
        super(name, labelText, pattern, style, width, parent);
    }

    public DateFieldEditor(String name, String labelText, String pattern, int style, int width, int strategy, Composite parent) {
        super(name, labelText, pattern, style, width, strategy, parent);
    }

    @Override
    protected void init(String pattern, int style, int validateStrategy, Composite parent) {
        super.init(pattern, style, validateStrategy, parent);
        if (this.getTextControl() != null) {
            this.getTextControl().addFocusListener((FocusListener)new DateFocusListener());
        }
    }

    @Override
    protected void doLoad() {
        super.doLoad();
        this.setToolTipText();
        this.updateFontStyle();
    }

    @Override
    protected void valueChanged() {
        super.valueChanged();
        this.updateFontStyle();
    }

    protected String getDefaultValue() {
        return this.getPreferenceStore().getDefaultString(this.getPreferenceName());
    }

    protected void setToolTipText() {
        String defaultValue;
        if (this.defaultToolTip && (defaultValue = this.getDefaultValue()) != null && !defaultValue.isEmpty()) {
            if (this.getTextControl() != null && !this.getTextControl().isDisposed()) {
                this.getTextControl().setToolTipText(JFaceMessages.get("lbl.preferences.default.value", defaultValue));
            } else if (this.getDateTimeControl() != null && !this.getDateTimeControl().isDisposed()) {
                this.getDateTimeControl().setToolTipText(JFaceMessages.get("lbl.preferences.default.value", defaultValue));
            }
        }
    }

    protected void updateFontStyle() {
        String defaultValue;
        if (this.boldCustomValues && (defaultValue = this.getDefaultValue()) != null && !defaultValue.isEmpty()) {
            if (this.getTextControl() != null) {
                formatter.updateFontStyle(this.getTextControl(), defaultValue);
            } else if (this.getDateTimeControl() != null) {
                try {
                    Date date = this.getDateValue();
                    formatter.updateFontStyle((Control)this.getDateTimeControl(), defaultValue, ((DateFormat)this.dateFormats.get()).format(date));
                }
                catch (ParseException pe) {
                    log.log(Level.SEVERE, JFaceMessages.get("err.date.parse"), pe);
                }
            }
        }
    }

    @Override
    public boolean isDefaultToolTip() {
        return this.defaultToolTip;
    }

    @Override
    public void setDefaultToolTip(boolean defaultToolTip) {
        this.defaultToolTip = defaultToolTip;
    }

    @Override
    public boolean isBoldCustomValues() {
        return this.boldCustomValues;
    }

    @Override
    public void setBoldCustomValues(boolean boldCustomValues) {
        this.boldCustomValues = boldCustomValues;
    }

    protected class DateFocusListener
    extends FocusAdapter {
        protected DateFocusListener() {
        }

        public void focusLost(FocusEvent fe) {
            if (DateFieldEditor.this.getValidateStrategy() == 0) {
                Text text = (Text)fe.widget;
                String oldText = text.getText();
                try {
                    DateFormat df = (DateFormat)DateFieldEditor.this.dateFormats.get();
                    String newText = df.format(df.parse(DateFieldEditor.this.getTextControl().getText()));
                    if (!oldText.equals(newText)) {
                        text.setText(newText);
                    }
                    DateFieldEditor.this.valueChanged();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
    }
}

