/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.preference.field;

import io.github.albertus82.jface.Formatter;
import io.github.albertus82.jface.JFaceMessages;
import io.github.albertus82.jface.preference.field.ComboFieldEditor;
import io.github.albertus82.jface.preference.field.FieldEditorDefault;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class DefaultComboFieldEditor
extends ComboFieldEditor
implements FieldEditorDefault {
    private static final Formatter formatter = new Formatter(DefaultComboFieldEditor.class);
    private boolean defaultToolTip = true;
    private boolean boldCustomValues = true;

    public DefaultComboFieldEditor(String name, String labelText, String[][] entryNamesAndValues, Composite parent) {
        super(name, labelText, entryNamesAndValues, parent);
    }

    @Override
    protected Combo getComboBoxControl(Composite parent) {
        Combo combo = this.getComboBoxControl();
        if (combo == null) {
            combo = new Combo(parent, 8);
            this.setComboBoxControl(combo);
            combo.setFont(parent.getFont());
            String[][] entryNamesAndValues = this.getEntryNamesAndValues();
            for (int i = 0; i < entryNamesAndValues.length; ++i) {
                combo.add(entryNamesAndValues[i][0], i);
            }
            combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    DefaultComboFieldEditor.this.updateValue();
                }
            });
        }
        return combo;
    }

    @Override
    protected void doLoad() {
        super.doLoad();
        this.setToolTipText();
        this.updateFontStyle();
    }

    @Override
    protected void doLoadDefault() {
        if (this.getDefaultValue() != null && !this.getDefaultValue().isEmpty()) {
            super.doLoadDefault();
            this.updateFontStyle();
        }
    }

    protected String getDefaultValue() {
        return this.getPreferenceStore().getDefaultString(this.getPreferenceName());
    }

    protected void updateValue() {
        String oldValue = this.getValue();
        String name = this.getComboBoxControl().getText();
        this.setValue(this.getValueForName(name));
        this.setPresentsDefaultValue(false);
        this.fireValueChanged("field_editor_value", oldValue, this.getValue());
        this.updateFontStyle();
    }

    protected String getNameForValue(String value) {
        String[][] entryNamesAndValues = this.getEntryNamesAndValues();
        for (int i = 0; i < entryNamesAndValues.length; ++i) {
            String[] entry = entryNamesAndValues[i];
            if (!value.equals(entry[1])) continue;
            return entry[0];
        }
        return entryNamesAndValues[0][0];
    }

    protected void updateFontStyle() {
        String defaultValue;
        if (this.boldCustomValues && (defaultValue = this.getDefaultValue()) != null && !defaultValue.isEmpty()) {
            formatter.updateFontStyle((Control)this.getComboBoxControl(), defaultValue, this.getValue());
        }
    }

    protected void setToolTipText() {
        if (this.defaultToolTip && this.getDefaultValue() != null && !this.getDefaultValue().isEmpty()) {
            String defaultValue = this.getNameForValue(this.getDefaultValue());
            if (this.getComboBoxControl() != null && !this.getComboBoxControl().isDisposed() && defaultValue != null && !defaultValue.isEmpty()) {
                this.getComboBoxControl().setToolTipText(JFaceMessages.get("lbl.preferences.default.value", defaultValue));
            }
        }
    }

    @Override
    public boolean isDefaultToolTip() {
        return this.defaultToolTip;
    }

    @Override
    public void setDefaultToolTip(boolean defaultToolTip) {
        this.defaultToolTip = defaultToolTip;
    }

    @Override
    public boolean isBoldCustomValues() {
        return this.boldCustomValues;
    }

    @Override
    public void setBoldCustomValues(boolean boldCustomValues) {
        this.boldCustomValues = boldCustomValues;
    }
}

