/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.preference.field;

import io.github.albertus82.jface.JFaceMessages;
import io.github.albertus82.jface.preference.field.FieldEditorDefault;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class DefaultRadioGroupFieldEditor
extends RadioGroupFieldEditor
implements FieldEditorDefault {
    private final String[][] labelsAndValues;
    private Composite radioBox;
    private boolean defaultToolTip = true;

    public DefaultRadioGroupFieldEditor(String name, String labelText, int numColumns, String[][] labelsAndValues, Composite parent) {
        super(name, labelText, numColumns, labelsAndValues, parent);
        this.labelsAndValues = labelsAndValues;
    }

    public DefaultRadioGroupFieldEditor(String name, String labelText, int numColumns, String[][] labelsAndValues, Composite parent, boolean useGroup) {
        super(name, labelText, numColumns, labelsAndValues, parent, useGroup);
        this.labelsAndValues = labelsAndValues;
    }

    public Composite getRadioBoxControl(Composite parent) {
        this.radioBox = super.getRadioBoxControl(parent);
        return this.radioBox;
    }

    protected void doLoadDefault() {
        if (this.getDefaultValue() != null && !this.getDefaultValue().isEmpty()) {
            super.doLoadDefault();
        } else {
            this.selectFirstButton();
        }
    }

    protected void selectFirstButton() {
        Control[] children = this.radioBox.getChildren();
        for (int i = 0; i < children.length; ++i) {
            Control control = children[i];
            if (!(control instanceof Button)) continue;
            Button button = (Button)control;
            if (i == 0) {
                button.setSelection(true);
                button.notifyListeners(13, null);
                continue;
            }
            button.setSelection(false);
        }
    }

    protected void doLoad() {
        super.doLoad();
        this.setToolTipText();
    }

    protected String getDefaultValue() {
        return this.getPreferenceStore().getDefaultString(this.getPreferenceName());
    }

    protected String getNameForValue(String value) {
        for (int i = 0; i < this.labelsAndValues.length; ++i) {
            String[] entry = this.labelsAndValues[i];
            if (!value.equals(entry[1])) continue;
            return entry[0];
        }
        return this.labelsAndValues[0][0];
    }

    protected void setToolTipText() {
        if (this.defaultToolTip && this.getDefaultValue() != null && !this.getDefaultValue().isEmpty()) {
            String defaultValue = this.getNameForValue(this.getDefaultValue());
            if (this.radioBox != null && !this.radioBox.isDisposed() && defaultValue != null && !defaultValue.isEmpty()) {
                this.radioBox.setToolTipText(JFaceMessages.get("lbl.preferences.default.value", defaultValue));
            }
        }
    }

    protected String[][] getLabelsAndValues() {
        return this.labelsAndValues;
    }

    protected Composite getRadioBox() {
        return this.radioBox;
    }

    @Override
    public boolean isDefaultToolTip() {
        return this.defaultToolTip;
    }

    @Override
    public void setDefaultToolTip(boolean defaultToolTip) {
        this.defaultToolTip = defaultToolTip;
    }

    @Override
    public boolean isBoldCustomValues() {
        return false;
    }

    @Override
    public void setBoldCustomValues(boolean boldCustomValues) {
    }
}

