/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.preference.field;

import io.github.albertus82.jface.listener.DoubleVerifyListener;
import io.github.albertus82.jface.preference.field.AbstractDecimalFieldEditor;
import io.github.albertus82.util.ISupplier;
import io.github.albertus82.util.Supplier;
import io.github.albertus82.util.logging.LoggerFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class DoubleFieldEditor
extends AbstractDecimalFieldEditor<Double> {
    private static final Logger log = LoggerFactory.getLogger(DoubleFieldEditor.class);
    private static final int DEFAULT_TEXT_LIMIT = 32;

    public DoubleFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
        this.getTextControl().addVerifyListener((VerifyListener)new DoubleVerifyListener((ISupplier<Boolean>)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return DoubleFieldEditor.this.getMinValidValue() == null || (Double)DoubleFieldEditor.this.getMinValidValue() < 0.0;
            }
        }));
        this.getTextControl().addFocusListener((FocusListener)new DoubleFocusListener());
    }

    @Override
    protected int getDefaultTextLimit() {
        return 32;
    }

    @Override
    protected void doLoad() {
        super.doLoad();
        Text text = this.getTextControl();
        if (text != null) {
            String value;
            try {
                value = Double.valueOf(this.getPreferenceStore().getString(this.getPreferenceName()).trim()).toString();
            }
            catch (NumberFormatException e) {
                log.log(Level.FINEST, "The value provided does not contain a parsable double:", e);
                value = "";
            }
            text.setText(value);
            this.oldValue = value;
        }
        this.updateFontStyle();
    }

    protected void doStore() {
        Text text = this.getTextControl();
        if (text != null) {
            if (text.getText().isEmpty() && this.isEmptyStringAllowed()) {
                this.getPreferenceStore().setValue(this.getPreferenceName(), "");
            } else {
                Double value = Double.valueOf(text.getText());
                this.getPreferenceStore().setValue(this.getPreferenceName(), value.toString());
            }
        }
    }

    @Override
    protected String getDefaultValue() {
        String defaultValue = super.getDefaultValue();
        try {
            return Double.valueOf(defaultValue).toString();
        }
        catch (NumberFormatException e) {
            log.log(Level.FINEST, "The value provided does not contain a parsable double:", e);
            return "";
        }
    }

    public Double getNumberValue() {
        return Double.valueOf(this.getStringValue());
    }

    protected class DoubleFocusListener
    extends FocusAdapter {
        protected DoubleFocusListener() {
        }

        public void focusLost(FocusEvent fe) {
            Text text = (Text)fe.widget;
            String oldText = text.getText();
            try {
                String newText = Double.toString(Double.parseDouble(oldText));
                if (!oldText.equals(newText)) {
                    text.setText(newText);
                }
                DoubleFieldEditor.this.valueChanged();
            }
            catch (Exception e) {
                log.log(Level.FINE, "Cannot change the value of the field:", e);
            }
        }
    }
}

