/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.preference.field;

import io.github.albertus82.jface.preference.field.ComboFieldEditor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class EditableComboFieldEditor
extends ComboFieldEditor {
    private int textLimit = 8192;

    public EditableComboFieldEditor(String name, String labelText, String[][] entryNamesAndValues, Composite parent) {
        super(name, labelText, entryNamesAndValues, parent);
    }

    @Override
    protected void doFillIntoGrid(Composite parent, int numColumns) {
        int comboColumns = 1;
        if (numColumns > 1) {
            comboColumns = numColumns - 1;
        }
        Label label = this.getLabelControl(parent);
        GridDataFactory.swtDefaults().applyTo((Control)label);
        Combo combo = this.getComboBoxControl(parent);
        GridDataFactory.swtDefaults().span(comboColumns, 1).align(4, 0x1000000).hint(combo.computeSize((int)-1, (int)-1).x, -1).grab(true, false).applyTo((Control)combo);
        combo.setFont(parent.getFont());
    }

    @Override
    protected Combo getComboBoxControl(Composite parent) {
        Combo combo = this.getComboBoxControl();
        if (combo == null) {
            combo = new Combo(parent, 0);
            this.setComboBoxControl(combo);
            combo.setFont(parent.getFont());
            String[][] entryNamesAndValues = this.getEntryNamesAndValues();
            for (int i = 0; i < entryNamesAndValues.length; ++i) {
                combo.add(entryNamesAndValues[i][0], i);
            }
            combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent se) {
                    EditableComboFieldEditor.this.updateValue();
                }
            });
            combo.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent fe) {
                    EditableComboFieldEditor.this.updateValue();
                }
            });
            if (this.textLimit > 0) {
                combo.setTextLimit(this.textLimit);
            }
        }
        return combo;
    }

    @Override
    protected void updateComboForValue(String value) {
        this.setValue(value);
        this.getComboBoxControl().setText(this.getNameForValue(value));
    }

    @Override
    protected String getValueForName(String name) {
        for (String[] entry : this.getEntryNamesAndValues()) {
            if (!name.equals(entry[0])) continue;
            return entry[1];
        }
        return name;
    }

    public void store() {
        this.updateValue();
        super.store();
    }

    protected String getNameForValue(String value) {
        for (String[] entry : this.getEntryNamesAndValues()) {
            if (!value.equals(entry[1])) continue;
            return entry[0];
        }
        return value;
    }

    protected void updateValue() {
        Combo combo = this.getComboBoxControl();
        if (combo != null && !combo.isDisposed()) {
            String oldValue = this.getValue();
            String name = combo.getText();
            this.setValue(this.getValueForName(name));
            this.setPresentsDefaultValue(false);
            this.fireValueChanged("field_editor_value", oldValue, this.getValue());
        }
    }

    public void setTextLimit(int limit) {
        this.textLimit = limit;
        if (this.getComboBoxControl() != null) {
            this.getComboBoxControl().setTextLimit(limit);
        }
    }

    protected int getMaxLabelLength() {
        int length = 0;
        for (String[] entry : this.getEntryNamesAndValues()) {
            if (entry[0].length() <= length) continue;
            length = entry[0].length();
        }
        return length;
    }
}

