/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.preference.field;

import io.github.albertus82.jface.JFaceMessages;
import io.github.albertus82.jface.preference.field.EnhancedListEditor;
import io.github.albertus82.util.EmailUtils;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EmailAddressesListEditor
extends EnhancedListEditor {
    public static final String EMAIL_ADDRESSES_SPLIT_REGEX = "[,;\\s]+";
    public static final char SEPARATOR = ',';
    private final Image[] images;

    public EmailAddressesListEditor(String name, String labelText, Composite parent, Integer horizontalSpan, Image ... images) {
        super(name, labelText, parent, horizontalSpan);
        this.images = images;
    }

    @Override
    protected void createButtons(Composite box) {
        this.createAddButton(box);
        this.createEditButton(box);
        this.createRemoveButton(box);
    }

    @Override
    protected String createList(String[] emailAddresses) {
        StringBuilder list = new StringBuilder();
        if (emailAddresses != null) {
            for (int index = 0; index < emailAddresses.length; ++index) {
                list.append(emailAddresses[index].trim());
                if (index == emailAddresses.length - 1) continue;
                list.append(',');
            }
        }
        return list.toString();
    }

    @Override
    protected String getNewInputObject() {
        EmailAddressDialog emailAddressDialog = new EmailAddressDialog(this.getShell());
        emailAddressDialog.create(JFaceMessages.get("lbl.preferences.email.dialog.add.title"));
        if (emailAddressDialog.open() == 0) {
            return emailAddressDialog.getEmailAddress();
        }
        return null;
    }

    @Override
    protected String getModifiedInputObject(String value) {
        EmailAddressDialog emailAddressDialog = new EmailAddressDialog(this.getShell());
        emailAddressDialog.create(JFaceMessages.get("lbl.preferences.email.dialog.edit.title"));
        emailAddressDialog.textEmailAddress.setText(value);
        if (emailAddressDialog.open() == 0) {
            return emailAddressDialog.getEmailAddress();
        }
        return null;
    }

    @Override
    protected String[] parseString(String stringList) {
        if (stringList != null && !stringList.isEmpty()) {
            return stringList.trim().split(EMAIL_ADDRESSES_SPLIT_REGEX);
        }
        return new String[0];
    }

    protected class EmailAddressDialog
    extends TitleAreaDialog {
        private static final int MAX_LENGTH = 254;
        private Text textEmailAddress;
        private Button okButton;
        private String emailAddress;

        public EmailAddressDialog(Shell parentShell) {
            super(parentShell);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            if (EmailAddressesListEditor.this.images != null && EmailAddressesListEditor.this.images.length > 0) {
                newShell.setImages(EmailAddressesListEditor.this.images);
            }
        }

        public void create(String title) {
            super.create();
            this.getShell().setText(title);
            this.setTitle(title);
            this.setMessage(JFaceMessages.get("lbl.preferences.email.dialog.message"), 1);
        }

        protected Composite createDialogArea(Composite parent) {
            Composite area = (Composite)super.createDialogArea(parent);
            Composite container = new Composite(area, 0);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)container);
            GridLayoutFactory.swtDefaults().numColumns(2).equalWidth(false).applyTo(container);
            Label labelName = new Label(container, 0);
            labelName.setText(JFaceMessages.get("lbl.preferences.email.dialog.address"));
            GridDataFactory.swtDefaults().applyTo((Control)labelName);
            this.textEmailAddress = new Text(container, 2048);
            GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.textEmailAddress);
            this.textEmailAddress.setTextLimit(254);
            this.textEmailAddress.addModifyListener((ModifyListener)new TextModifyListener());
            return area;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            this.okButton = this.getButton(0);
            this.okButton.setText(JFaceMessages.get("lbl.button.ok"));
            this.okButton.setEnabled(false);
            Button cancelButton = this.getButton(1);
            cancelButton.setText(JFaceMessages.get("lbl.button.cancel"));
        }

        protected boolean isResizable() {
            return true;
        }

        protected void okPressed() {
            this.emailAddress = this.textEmailAddress.getText().trim();
            super.okPressed();
        }

        public String getEmailAddress() {
            return this.emailAddress;
        }

        private class TextModifyListener
        implements ModifyListener {
            private TextModifyListener() {
            }

            public void modifyText(ModifyEvent me) {
                if (!EmailUtils.validateAddress(EmailAddressDialog.this.textEmailAddress.getText().trim())) {
                    if (EmailAddressDialog.this.okButton.isEnabled()) {
                        EmailAddressDialog.this.okButton.setEnabled(false);
                    }
                } else if (!EmailAddressDialog.this.okButton.isEnabled()) {
                    EmailAddressDialog.this.okButton.setEnabled(true);
                }
            }
        }
    }
}

