/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.preference.field;

import io.github.albertus82.jface.Formatter;
import io.github.albertus82.jface.JFaceMessages;
import io.github.albertus82.jface.preference.field.FieldEditorDefault;
import io.github.albertus82.util.ISupplier;
import java.io.File;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Text;

public class EnhancedDirectoryFieldEditor
extends DirectoryFieldEditor
implements FieldEditorDefault {
    private static final Formatter formatter = new Formatter(EnhancedDirectoryFieldEditor.class);
    public static final int MAX_PATH = 255;
    private boolean localized;
    private File filterPath = null;
    private ISupplier<String> dialogMessage;
    private boolean defaultToolTip = true;
    private boolean boldCustomValues = true;
    private boolean checkExistence = true;
    private ControlDecoration controlDecorator;

    public EnhancedDirectoryFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
        this.setErrorMessage(JFaceMessages.get("err.preferences.directory"));
        this.setTextLimit(255);
        this.addDecoration();
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        super.doFillIntoGrid(parent, numColumns);
        Text control = this.getTextControl();
        if (control != null && !control.isDisposed() && control.getLayoutData() instanceof GridData) {
            GridData gd = (GridData)control.getLayoutData();
            gd.widthHint = control.computeSize((int)-1, (int)-1).x;
            gd.grabExcessHorizontalSpace = false;
        }
    }

    protected Button getChangeControl(Composite parent) {
        Button browseButton = super.getChangeControl(parent);
        if (!this.localized) {
            browseButton.setText(JFaceMessages.get("lbl.button.browse"));
            this.localized = true;
        }
        return browseButton;
    }

    protected void doLoad() {
        super.doLoad();
        this.setToolTipText();
        this.updateFontStyle();
    }

    protected void valueChanged() {
        super.valueChanged();
        this.updateFontStyle();
    }

    protected String changePressed() {
        File d;
        File f = new File(this.getTextControl().getText());
        if (!f.exists()) {
            f = null;
        }
        if ((d = this.getDirectory(f)) == null) {
            this.valueChanged();
            return null;
        }
        return d.getAbsolutePath();
    }

    public void setFilterPath(File filterPath) {
        super.setFilterPath(filterPath);
        this.filterPath = filterPath;
    }

    protected boolean checkState() {
        String txt;
        boolean result = this.isEmptyStringAllowed() ? true : (this.getTextControl() == null ? false : (txt = this.getTextControl().getText()).trim().length() > 0 || this.isEmptyStringAllowed());
        result = result && this.doCheckState();
        return result;
    }

    protected boolean doCheckState() {
        String fileName = this.getTextControl().getText();
        if ((fileName = fileName.trim()).isEmpty() && this.isEmptyStringAllowed()) {
            return true;
        }
        if (this.checkExistence) {
            return new File(fileName).isDirectory();
        }
        return !fileName.isEmpty();
    }

    protected void refreshValidState() {
        super.refreshValidState();
        String errorMessage = this.getErrorMessage();
        if (errorMessage != null && !errorMessage.isEmpty()) {
            if (this.isValid()) {
                this.clearErrorMessage();
            } else {
                this.showErrorMessage();
            }
        }
    }

    public void setStringValue(String value) {
        Text textField = this.getTextControl();
        if (textField != null) {
            String cleanedValue = value != null ? value : "";
            this.oldValue = textField.getText();
            if (!this.oldValue.equals(cleanedValue)) {
                textField.setText(cleanedValue);
            }
            this.valueChanged();
        }
    }

    protected void addDecoration() {
        this.controlDecorator = new ControlDecoration((Control)this.getTextControl(), 16512);
        this.controlDecorator.hide();
        Image image = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
        this.controlDecorator.setImage(image);
    }

    protected void showErrorMessage(String msg) {
        super.showErrorMessage(msg);
        if (this.controlDecorator != null) {
            this.controlDecorator.setDescriptionText(msg);
            this.controlDecorator.show();
        }
    }

    protected void clearErrorMessage() {
        super.clearErrorMessage();
        if (this.controlDecorator != null && this.isValid()) {
            this.controlDecorator.hide();
        }
    }

    public File getFilterPath() {
        return this.filterPath;
    }

    protected String getDefaultValue() {
        return this.getPreferenceStore().getDefaultString(this.getPreferenceName());
    }

    protected void setToolTipText() {
        if (this.defaultToolTip) {
            String defaultValue = this.getDefaultValue();
            if (this.getTextControl() != null && !this.getTextControl().isDisposed() && defaultValue != null && !defaultValue.isEmpty()) {
                this.getTextControl().setToolTipText(JFaceMessages.get("lbl.preferences.default.value", defaultValue));
            }
        }
    }

    protected void updateFontStyle() {
        String defaultValue;
        if (this.boldCustomValues && (defaultValue = this.getDefaultValue()) != null && !defaultValue.isEmpty()) {
            formatter.updateFontStyle(this.getTextControl(), defaultValue);
        }
    }

    protected File getDirectory(File startingDirectory) {
        DirectoryDialog fileDialog = new DirectoryDialog(this.getShell(), 0x10001000);
        if (this.dialogMessage != null && this.dialogMessage.get() != null) {
            fileDialog.setMessage(this.dialogMessage.get());
        }
        if (startingDirectory != null) {
            fileDialog.setFilterPath(startingDirectory.getPath());
        } else if (this.filterPath != null) {
            fileDialog.setFilterPath(this.filterPath.getPath());
        }
        String dir = fileDialog.open();
        if (dir != null && (dir = dir.trim()).length() > 0) {
            return new File(dir);
        }
        return null;
    }

    public ISupplier<String> getDialogMessage() {
        return this.dialogMessage;
    }

    public void setDialogMessage(ISupplier<String> dialogMessage) {
        this.dialogMessage = dialogMessage;
    }

    public void setCheckExistence(boolean checkExistence) {
        this.checkExistence = checkExistence;
    }

    @Override
    public boolean isDefaultToolTip() {
        return this.defaultToolTip;
    }

    @Override
    public void setDefaultToolTip(boolean defaultToolTip) {
        this.defaultToolTip = defaultToolTip;
    }

    @Override
    public boolean isBoldCustomValues() {
        return this.boldCustomValues;
    }

    @Override
    public void setBoldCustomValues(boolean boldCustomValues) {
        this.boldCustomValues = boldCustomValues;
    }

    protected ControlDecoration getControlDecorator() {
        return this.controlDecorator;
    }
}

