/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.preference.field;

import io.github.albertus82.jface.Formatter;
import io.github.albertus82.jface.JFaceMessages;
import io.github.albertus82.jface.preference.field.FieldEditorDefault;
import java.io.File;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class EnhancedFileFieldEditor
extends FileFieldEditor
implements FieldEditorDefault {
    private static final String MSG_KEY_ERROR_ABSOLUTE_PATH = "err.preferences.file.absolute.path";
    private static final String MSG_KEY_ERROR_FILE_EXISTING = "err.preferences.file.existing";
    private static final Formatter formatter = new Formatter(EnhancedFileFieldEditor.class);
    public static final int MAX_PATH = 255;
    private boolean localized;
    private boolean enforceAbsolute;
    private boolean defaultToolTip = true;
    private boolean boldCustomValues = true;
    private ControlDecoration controlDecorator;

    protected EnhancedFileFieldEditor() {
    }

    public EnhancedFileFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
        this.init();
    }

    public EnhancedFileFieldEditor(String name, String labelText, boolean enforceAbsolute, Composite parent) {
        super(name, labelText, enforceAbsolute, parent);
        this.enforceAbsolute = enforceAbsolute;
        this.init();
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        super.doFillIntoGrid(parent, numColumns);
        Text control = this.getTextControl();
        if (control != null && !control.isDisposed() && control.getLayoutData() instanceof GridData) {
            GridData gd = (GridData)control.getLayoutData();
            gd.widthHint = control.computeSize((int)-1, (int)-1).x;
            gd.grabExcessHorizontalSpace = false;
        }
    }

    protected Button getChangeControl(Composite parent) {
        Button browseButton = super.getChangeControl(parent);
        if (!this.localized) {
            browseButton.setText(JFaceMessages.get("lbl.button.browse"));
            this.localized = true;
        }
        return browseButton;
    }

    protected void doLoad() {
        super.doLoad();
        this.setToolTipText();
        this.updateFontStyle();
    }

    protected void valueChanged() {
        super.valueChanged();
        this.updateFontStyle();
    }

    protected void refreshValidState() {
        super.refreshValidState();
        String errorMessage = this.getErrorMessage();
        if (errorMessage != null && !errorMessage.isEmpty()) {
            if (this.isValid()) {
                this.clearErrorMessage();
            } else {
                this.showErrorMessage();
            }
        }
    }

    protected boolean checkState() {
        String path = this.getTextControl().getText();
        path = path != null ? path.trim() : "";
        String msg = null;
        if (path.length() == 0) {
            if (!this.isEmptyStringAllowed()) {
                msg = JFaceMessages.get(MSG_KEY_ERROR_FILE_EXISTING);
            }
        } else {
            File file = new File(path);
            if (file.isFile()) {
                if (this.enforceAbsolute && !file.isAbsolute()) {
                    msg = JFaceMessages.get(MSG_KEY_ERROR_ABSOLUTE_PATH);
                }
            } else {
                msg = JFaceMessages.get(MSG_KEY_ERROR_FILE_EXISTING);
            }
        }
        if (msg != null) {
            this.setErrorMessage(msg);
            return false;
        }
        return this.doCheckState();
    }

    protected String getDefaultValue() {
        return this.getPreferenceStore().getDefaultString(this.getPreferenceName());
    }

    protected void setToolTipText() {
        if (this.defaultToolTip) {
            String defaultValue = this.getDefaultValue();
            if (this.getTextControl() != null && !this.getTextControl().isDisposed() && defaultValue != null && !defaultValue.isEmpty()) {
                this.getTextControl().setToolTipText(JFaceMessages.get("lbl.preferences.default.value", defaultValue));
            }
        }
    }

    protected void updateFontStyle() {
        String defaultValue;
        if (this.boldCustomValues && (defaultValue = this.getDefaultValue()) != null && !defaultValue.isEmpty()) {
            formatter.updateFontStyle(this.getTextControl(), defaultValue);
        }
    }

    protected void init() {
        this.setErrorMessage(JFaceMessages.get(MSG_KEY_ERROR_FILE_EXISTING));
        this.setTextLimit(255);
        this.addDecoration();
    }

    protected void addDecoration() {
        this.controlDecorator = new ControlDecoration((Control)this.getTextControl(), 16512);
        this.controlDecorator.hide();
        Image image = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
        this.controlDecorator.setImage(image);
    }

    protected void showErrorMessage(String msg) {
        super.showErrorMessage(msg);
        if (this.controlDecorator != null) {
            this.controlDecorator.setDescriptionText(msg);
            this.controlDecorator.show();
        }
    }

    protected void clearErrorMessage() {
        super.clearErrorMessage();
        if (this.controlDecorator != null && this.isValid()) {
            this.controlDecorator.hide();
        }
    }

    @Override
    public boolean isDefaultToolTip() {
        return this.defaultToolTip;
    }

    @Override
    public void setDefaultToolTip(boolean defaultToolTip) {
        this.defaultToolTip = defaultToolTip;
    }

    @Override
    public boolean isBoldCustomValues() {
        return this.boldCustomValues;
    }

    @Override
    public void setBoldCustomValues(boolean boldCustomValues) {
        this.boldCustomValues = boldCustomValues;
    }

    protected ControlDecoration getControlDecorator() {
        return this.controlDecorator;
    }
}

