/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.preference.field;

import io.github.albertus82.jface.listener.IntegerVerifyListener;
import io.github.albertus82.jface.preference.field.AbstractIntegerFieldEditor;
import io.github.albertus82.util.ISupplier;
import io.github.albertus82.util.Supplier;
import io.github.albertus82.util.logging.LoggerFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class EnhancedIntegerFieldEditor
extends AbstractIntegerFieldEditor<Integer> {
    private static final Logger log = LoggerFactory.getLogger(EnhancedIntegerFieldEditor.class);
    private static final int DEFAULT_TEXT_LIMIT = Integer.toString(Integer.MAX_VALUE).length() - 1;

    public EnhancedIntegerFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
        this.setMinValidValue(0);
        this.getTextControl().addVerifyListener((VerifyListener)new IntegerVerifyListener((ISupplier<Boolean>)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return EnhancedIntegerFieldEditor.this.getMinValidValue() == null || (Integer)EnhancedIntegerFieldEditor.this.getMinValidValue() < 0;
            }
        }));
        this.getTextControl().addFocusListener((FocusListener)new IntegerFocusListener());
    }

    @Override
    protected int getDefaultTextLimit() {
        return DEFAULT_TEXT_LIMIT;
    }

    @Override
    protected void doLoad() {
        super.doLoad();
        Text text = this.getTextControl();
        if (text != null) {
            String value;
            try {
                value = Integer.valueOf(this.getPreferenceStore().getString(this.getPreferenceName()).trim()).toString();
            }
            catch (NumberFormatException e) {
                log.log(Level.FINEST, "The value provided does not contain a parsable int:", e);
                value = "";
            }
            text.setText(value);
            this.oldValue = value;
        }
        this.updateFontStyle();
    }

    protected void doStore() {
        Text text = this.getTextControl();
        if (text != null) {
            if (text.getText().isEmpty() && this.isEmptyStringAllowed()) {
                this.getPreferenceStore().setValue(this.getPreferenceName(), "");
            } else {
                Integer value = Integer.valueOf(text.getText());
                this.getPreferenceStore().setValue(this.getPreferenceName(), value.toString());
            }
        }
    }

    @Override
    protected String getDefaultValue() {
        String defaultValue = super.getDefaultValue();
        try {
            return Integer.valueOf(defaultValue).toString();
        }
        catch (NumberFormatException e) {
            log.log(Level.FINEST, "The value provided does not contain a parsable int:", e);
            return "";
        }
    }

    public Integer getNumberValue() {
        return Integer.valueOf(this.getStringValue());
    }

    protected class IntegerFocusListener
    extends FocusAdapter {
        protected IntegerFocusListener() {
        }

        public void focusLost(FocusEvent fe) {
            Text text = (Text)fe.widget;
            String oldText = text.getText();
            try {
                String newText = Integer.toString(Integer.parseInt(oldText));
                if (!oldText.equals(newText)) {
                    text.setText(newText);
                }
                EnhancedIntegerFieldEditor.this.valueChanged();
            }
            catch (Exception e) {
                log.log(Level.FINE, "Cannot change the value of the field:", e);
            }
        }
    }
}

