/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.preference.field;

import io.github.albertus82.jface.JFaceMessages;
import javax.annotation.Nullable;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public abstract class EnhancedListEditor
extends FieldEditor {
    private final boolean container;
    @Nullable
    private List list;
    @Nullable
    private Composite buttonBox;
    @Nullable
    private Button addButton;
    @Nullable
    private Button editButton;
    @Nullable
    private Button removeButton;
    @Nullable
    private Button upButton;
    @Nullable
    private Button downButton;
    @Nullable
    private SelectionListener selectionListener;

    protected EnhancedListEditor() {
        this.container = false;
    }

    protected EnhancedListEditor(String name, String labelText, Composite parent) {
        this(name, labelText, parent, null);
    }

    protected EnhancedListEditor(String name, String labelText, Composite parent, Integer horizontalSpan) {
        super(name, labelText, horizontalSpan != null && horizontalSpan > 0 ? EnhancedListEditor.createContainer(parent, horizontalSpan) : parent);
        this.container = horizontalSpan != null && horizontalSpan > 0;
    }

    protected static Composite createContainer(Composite fieldEditorParent, int horizontalSpan) {
        Composite parent = new Composite(fieldEditorParent, 0);
        GridDataFactory.swtDefaults().align(4, 0x1000000).span(horizontalSpan, 1).applyTo((Control)parent);
        return parent;
    }

    protected void checkParent(Control control, Composite parent) {
        super.checkParent((Control)(this.container ? control.getParent() : control), parent);
    }

    protected void addPressed() {
        this.setPresentsDefaultValue(false);
        String input = this.getNewInputObject();
        if (input != null) {
            int index = this.list.getSelectionIndex();
            if (index >= 0) {
                this.list.add(input, index + 1);
            } else {
                this.list.add(input, 0);
            }
            this.selectionChanged();
        }
    }

    protected void editPressed() {
        this.setPresentsDefaultValue(false);
        int index = this.list.getSelectionIndex();
        String input = this.getModifiedInputObject(this.list.getItem(index));
        if (input != null && index >= 0) {
            this.list.setItem(index, input);
            this.selectionChanged();
        }
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.list.getLayoutData()).horizontalSpan = numColumns - 1;
    }

    protected abstract String createList(String[] var1);

    protected Button createPushButton(Composite parent, String text) {
        Button button = new Button(parent, 8);
        button.setText(text);
        button.setFont(parent.getFont());
        GridData data = new GridData(768);
        int widthHint = this.convertHorizontalDLUsToPixels((Control)button, 61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        button.addSelectionListener(this.getSelectionListener());
        return button;
    }

    protected ListEditorSelectionListener createSelectionListener() {
        return new ListEditorSelectionListener();
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        control.setLayoutData((Object)gd);
        this.list = this.getListControl(parent);
        gd = new GridData(768);
        gd.verticalAlignment = 4;
        gd.horizontalSpan = numColumns - 1;
        gd.widthHint = this.list.computeSize((int)-1, (int)-1).x;
        gd.grabExcessHorizontalSpace = false;
        this.list.setLayoutData((Object)gd);
        this.buttonBox = this.getButtonBoxControl(parent);
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.buttonBox.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        if (this.list != null) {
            String s = this.getPreferenceStore().getString(this.getPreferenceName());
            String[] array = this.parseString(s);
            for (int i = 0; i < array.length; ++i) {
                this.list.add(array[i]);
            }
        }
    }

    protected void doLoadDefault() {
        if (this.list != null) {
            this.list.removeAll();
            String s = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            String[] array = this.parseString(s);
            for (int i = 0; i < array.length; ++i) {
                this.list.add(array[i]);
            }
        }
    }

    protected void doStore() {
        String s = this.createList(this.list.getItems());
        if (s != null) {
            this.getPreferenceStore().setValue(this.getPreferenceName(), s);
        }
    }

    protected void createButtons(Composite box) {
        this.createAddButton(box);
        this.createRemoveButton(box);
        this.createUpButton(box);
        this.createDownButton(box);
    }

    protected void createAddButton(Composite box) {
        this.addButton = this.createPushButton(box, JFaceMessages.get("lbl.preferences.list.button.add"));
    }

    protected void createEditButton(Composite box) {
        this.editButton = this.createPushButton(box, JFaceMessages.get("lbl.preferences.list.button.edit"));
    }

    protected void createRemoveButton(Composite box) {
        this.removeButton = this.createPushButton(box, JFaceMessages.get("lbl.preferences.list.button.remove"));
    }

    protected void createUpButton(Composite box) {
        this.upButton = this.createPushButton(box, JFaceMessages.get("lbl.preferences.list.button.up"));
    }

    protected void createDownButton(Composite box) {
        this.downButton = this.createPushButton(box, JFaceMessages.get("lbl.preferences.list.button.down"));
    }

    public Composite getButtonBoxControl(Composite parent) {
        if (this.buttonBox == null) {
            this.buttonBox = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            this.buttonBox.setLayout((Layout)layout);
            this.createButtons(this.buttonBox);
            this.buttonBox.addDisposeListener((DisposeListener)this.createButtonBoxDisposeListener());
        } else {
            this.checkParent((Control)this.buttonBox, parent);
        }
        this.selectionChanged();
        return this.buttonBox;
    }

    protected ButtonBoxDisposeListener createButtonBoxDisposeListener() {
        return new ButtonBoxDisposeListener();
    }

    public List getListControl(Composite parent) {
        if (this.list == null) {
            this.list = new List(parent, 2820);
            this.list.setFont(parent.getFont());
            this.list.addSelectionListener(this.getSelectionListener());
            this.list.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    EnhancedListEditor.this.list = null;
                }
            });
        } else {
            this.checkParent((Control)this.list, parent);
        }
        return this.list;
    }

    protected abstract String getNewInputObject();

    protected String getModifiedInputObject(String value) {
        return null;
    }

    public int getNumberOfControls() {
        return 2;
    }

    protected SelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.selectionListener = this.createSelectionListener();
        }
        return this.selectionListener;
    }

    protected Shell getShell() {
        if (this.addButton == null) {
            return null;
        }
        return this.addButton.getShell();
    }

    protected abstract String[] parseString(String var1);

    protected void removePressed() {
        this.setPresentsDefaultValue(false);
        int index = this.list.getSelectionIndex();
        if (index >= 0) {
            this.list.remove(index);
            int size = this.list.getItemCount();
            if (size > 0) {
                if (index < size) {
                    this.list.setSelection(index);
                } else {
                    this.list.setSelection(size - 1);
                }
            }
            this.selectionChanged();
        }
    }

    protected void selectionChanged() {
        int index = this.list.getSelectionIndex();
        int size = this.list.getItemCount();
        if (this.editButton != null && !this.editButton.isDisposed()) {
            this.editButton.setEnabled(index >= 0);
        }
        if (this.removeButton != null && !this.removeButton.isDisposed()) {
            this.removeButton.setEnabled(index >= 0);
        }
        if (this.upButton != null && !this.upButton.isDisposed()) {
            this.upButton.setEnabled(size > 1 && index > 0);
        }
        if (this.downButton != null && !this.downButton.isDisposed()) {
            this.downButton.setEnabled(size > 1 && index >= 0 && index < size - 1);
        }
    }

    public void setFocus() {
        if (this.list != null) {
            this.list.setFocus();
        }
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        boolean hasSelection = this.list.getSelectionIndex() >= 0;
        this.getListControl(parent).setEnabled(enabled);
        if (this.addButton != null && !this.addButton.isDisposed()) {
            this.addButton.setEnabled(enabled);
        }
        if (this.editButton != null && !this.editButton.isDisposed()) {
            this.editButton.setEnabled(enabled && hasSelection);
        }
        if (this.removeButton != null && !this.removeButton.isDisposed()) {
            this.removeButton.setEnabled(enabled && hasSelection);
        }
        if (this.upButton != null && !this.upButton.isDisposed()) {
            this.upButton.setEnabled(enabled && hasSelection);
        }
        if (this.downButton != null && !this.downButton.isDisposed()) {
            this.downButton.setEnabled(enabled && hasSelection);
        }
    }

    protected void upPressed() {
        this.swap(true);
    }

    protected void downPressed() {
        this.swap(false);
    }

    protected void swap(boolean up) {
        int target;
        this.setPresentsDefaultValue(false);
        int index = this.list.getSelectionIndex();
        int n = target = up ? index - 1 : index + 1;
        if (index >= 0) {
            String[] selection = this.list.getSelection();
            Assert.isTrue((selection.length == 1 ? 1 : 0) != 0);
            this.list.remove(index);
            this.list.add(selection[0], target);
            this.list.setSelection(target);
        }
        this.selectionChanged();
    }

    protected List getList() {
        return this.list;
    }

    protected Composite getButtonBox() {
        return this.buttonBox;
    }

    protected Button getAddButton() {
        return this.addButton;
    }

    protected Button getEditButton() {
        return this.editButton;
    }

    protected Button getRemoveButton() {
        return this.removeButton;
    }

    protected Button getUpButton() {
        return this.upButton;
    }

    protected Button getDownButton() {
        return this.downButton;
    }

    protected class ListEditorSelectionListener
    extends SelectionAdapter {
        protected ListEditorSelectionListener() {
        }

        public void widgetSelected(@Nullable SelectionEvent se) {
            if (se != null && se.widget != null) {
                Widget widget = se.widget;
                if (widget == EnhancedListEditor.this.addButton) {
                    EnhancedListEditor.this.addPressed();
                } else if (widget == EnhancedListEditor.this.editButton) {
                    EnhancedListEditor.this.editPressed();
                } else if (widget == EnhancedListEditor.this.removeButton) {
                    EnhancedListEditor.this.removePressed();
                } else if (widget == EnhancedListEditor.this.upButton) {
                    EnhancedListEditor.this.upPressed();
                } else if (widget == EnhancedListEditor.this.downButton) {
                    EnhancedListEditor.this.downPressed();
                } else if (widget == EnhancedListEditor.this.list) {
                    EnhancedListEditor.this.selectionChanged();
                }
            }
        }
    }

    protected class ButtonBoxDisposeListener
    implements DisposeListener {
        protected ButtonBoxDisposeListener() {
        }

        public void widgetDisposed(DisposeEvent event) {
            EnhancedListEditor.this.addButton = null;
            EnhancedListEditor.this.editButton = null;
            EnhancedListEditor.this.removeButton = null;
            EnhancedListEditor.this.upButton = null;
            EnhancedListEditor.this.downButton = null;
            EnhancedListEditor.this.buttonBox = null;
        }
    }
}

