/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.preference.field;

import io.github.albertus82.jface.Formatter;
import io.github.albertus82.jface.JFaceMessages;
import io.github.albertus82.jface.preference.field.FieldEditorDefault;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class EnhancedStringFieldEditor
extends StringFieldEditor
implements FieldEditorDefault {
    private static final Formatter formatter = new Formatter(EnhancedStringFieldEditor.class);
    private boolean defaultToolTip = true;
    private boolean boldCustomValues = true;
    private ControlDecoration controlDecorator;

    protected EnhancedStringFieldEditor() {
    }

    public EnhancedStringFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
        this.init();
    }

    public EnhancedStringFieldEditor(String name, String labelText, int width, Composite parent) {
        super(name, labelText, width, parent);
        this.init();
    }

    public EnhancedStringFieldEditor(String name, String labelText, int width, int strategy, Composite parent) {
        super(name, labelText, width, strategy, parent);
        this.init();
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        super.doFillIntoGrid(parent, numColumns);
        Text control = this.getTextControl();
        if (control != null && !control.isDisposed() && control.getLayoutData() instanceof GridData) {
            GridData gd = (GridData)control.getLayoutData();
            gd.widthHint = control.computeSize((int)-1, (int)-1).x;
            gd.grabExcessHorizontalSpace = false;
        }
    }

    protected void doLoad() {
        super.doLoad();
        this.setToolTipText();
        this.updateFontStyle();
    }

    protected void doLoadDefault() {
        Text text = this.getTextControl();
        if (text != null) {
            String value = this.getDefaultValue();
            text.setText(value);
        }
        this.valueChanged();
    }

    protected void valueChanged() {
        super.valueChanged();
        this.updateFontStyle();
    }

    protected String getDefaultValue() {
        return this.getPreferenceStore().getDefaultString(this.getPreferenceName());
    }

    protected void setToolTipText() {
        if (this.defaultToolTip) {
            String defaultValue = this.getDefaultValue();
            if (this.getTextControl() != null && !this.getTextControl().isDisposed() && defaultValue != null && !defaultValue.isEmpty()) {
                this.getTextControl().setToolTipText(JFaceMessages.get("lbl.preferences.default.value", defaultValue));
            }
        }
    }

    protected void updateFontStyle() {
        String defaultValue;
        if (this.boldCustomValues && (defaultValue = this.getDefaultValue()) != null && !defaultValue.isEmpty()) {
            formatter.updateFontStyle(this.getTextControl(), defaultValue);
        }
    }

    protected void init() {
        this.setErrorMessage(JFaceMessages.get("err.preferences.string"));
        this.setTextLimit(8192);
        this.addDecoration();
    }

    protected void addDecoration() {
        this.controlDecorator = new ControlDecoration((Control)this.getTextControl(), 16512);
        this.controlDecorator.hide();
        Image image = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
        this.controlDecorator.setImage(image);
    }

    protected boolean checkState() {
        Text text = this.getTextControl();
        if (text == null) {
            return false;
        }
        if (text.getText().isEmpty()) {
            return this.isEmptyStringAllowed();
        }
        return this.doCheckState();
    }

    protected boolean doCheckState() {
        return super.doCheckState();
    }

    protected void refreshValidState() {
        super.refreshValidState();
        String errorMessage = this.getErrorMessage();
        if (errorMessage != null && !errorMessage.isEmpty()) {
            if (this.isValid()) {
                this.clearErrorMessage();
            } else {
                this.showErrorMessage();
            }
        }
    }

    protected void showErrorMessage(String msg) {
        super.showErrorMessage(msg);
        if (this.controlDecorator != null) {
            this.controlDecorator.setDescriptionText(msg);
            this.controlDecorator.show();
        }
    }

    protected void clearErrorMessage() {
        super.clearErrorMessage();
        if (this.controlDecorator != null && this.isValid()) {
            this.controlDecorator.hide();
        }
    }

    @Override
    public boolean isDefaultToolTip() {
        return this.defaultToolTip;
    }

    @Override
    public void setDefaultToolTip(boolean defaultToolTip) {
        this.defaultToolTip = defaultToolTip;
    }

    @Override
    public boolean isBoldCustomValues() {
        return this.boldCustomValues;
    }

    @Override
    public void setBoldCustomValues(boolean boldCustomValues) {
        this.boldCustomValues = boldCustomValues;
    }

    protected ControlDecoration getControlDecorator() {
        return this.controlDecorator;
    }
}

