/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.preference.field;

import io.github.albertus82.jface.preference.field.AbstractDecimalComboFieldEditor;
import io.github.albertus82.util.logging.LoggerFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Composite;

public class FloatComboFieldEditor
extends AbstractDecimalComboFieldEditor<Float> {
    private static final Logger log = LoggerFactory.getLogger(FloatComboFieldEditor.class);
    private static final int DEFAULT_TEXT_LIMIT = 16;

    public FloatComboFieldEditor(String name, String labelText, String[][] entryNamesAndValues, Composite parent) {
        super(name, labelText, entryNamesAndValues, parent);
    }

    @Override
    protected int getDefaultTextLimit() {
        return 16;
    }

    @Override
    protected String cleanValue(String value) {
        String cleanValue = super.cleanValue(value);
        try {
            return Float.valueOf(cleanValue).toString();
        }
        catch (NumberFormatException e) {
            log.log(Level.FINEST, "The value provided does not contain a parsable float:", e);
            return cleanValue;
        }
    }

    @Override
    protected void cleanComboText() {
        String oldText = this.getComboBoxControl().getText();
        String newText = oldText.trim();
        try {
            newText = this.getNameForValue(Float.valueOf(newText).toString());
        }
        catch (Exception e) {
            log.log(Level.FINEST, "Cannot determine a name for the value provided:", e);
        }
        if (!newText.equals(oldText)) {
            this.getComboBoxControl().setText(newText);
        }
    }

    @Override
    public String getValue() {
        try {
            return Float.valueOf(super.getValue()).toString();
        }
        catch (Exception e) {
            log.log(Level.FINEST, "Cannot translate the string into a Float:", e);
            return super.getValue();
        }
    }

    @Override
    protected void setValue(String value) {
        try {
            super.setValue(Float.valueOf(value).toString());
        }
        catch (Exception e) {
            log.log(Level.FINEST, "Cannot translate the string into a Float:", e);
            super.setValue(value);
        }
    }

    @Override
    protected String getNameForValue(String value) {
        for (String[] entry : this.getEntryNamesAndValues()) {
            String comboValue;
            try {
                comboValue = Float.valueOf(entry[1]).toString();
            }
            catch (Exception e) {
                log.log(Level.FINE, "Cannot translate the string into a Float:", e);
                comboValue = entry[1];
            }
            if (!value.equals(comboValue)) continue;
            return entry[0];
        }
        return value;
    }

    public Float getNumberValue() {
        return Float.valueOf(this.getValue());
    }
}

