/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.preference.field;

import io.github.albertus82.jface.listener.FloatVerifyListener;
import io.github.albertus82.jface.preference.field.AbstractDecimalFieldEditor;
import io.github.albertus82.util.ISupplier;
import io.github.albertus82.util.Supplier;
import io.github.albertus82.util.logging.LoggerFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class FloatFieldEditor
extends AbstractDecimalFieldEditor<Float> {
    private static final Logger log = LoggerFactory.getLogger(FloatFieldEditor.class);
    private static final int DEFAULT_TEXT_LIMIT = 16;

    public FloatFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
        this.getTextControl().addVerifyListener((VerifyListener)new FloatVerifyListener((ISupplier<Boolean>)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return FloatFieldEditor.this.getMinValidValue() == null || ((Float)FloatFieldEditor.this.getMinValidValue()).floatValue() < 0.0f;
            }
        }));
        this.getTextControl().addFocusListener((FocusListener)new FloatFocusListener());
    }

    @Override
    protected int getDefaultTextLimit() {
        return 16;
    }

    @Override
    protected void doLoad() {
        super.doLoad();
        Text text = this.getTextControl();
        if (text != null) {
            String value;
            try {
                value = Float.valueOf(this.getPreferenceStore().getString(this.getPreferenceName()).trim()).toString();
            }
            catch (NumberFormatException e) {
                log.log(Level.FINEST, "The value provided does not contain a parsable float:", e);
                value = "";
            }
            text.setText(value);
            this.oldValue = value;
        }
        this.updateFontStyle();
    }

    protected void doStore() {
        Text text = this.getTextControl();
        if (text != null) {
            if (text.getText().isEmpty() && this.isEmptyStringAllowed()) {
                this.getPreferenceStore().setValue(this.getPreferenceName(), "");
            } else {
                Float value = Float.valueOf(text.getText());
                this.getPreferenceStore().setValue(this.getPreferenceName(), value.toString());
            }
        }
    }

    @Override
    protected String getDefaultValue() {
        String defaultValue = super.getDefaultValue();
        try {
            return Float.valueOf(defaultValue).toString();
        }
        catch (NumberFormatException e) {
            log.log(Level.FINEST, "The value provided does not contain a parsable float:", e);
            return "";
        }
    }

    public Float getNumberValue() {
        return Float.valueOf(this.getStringValue());
    }

    protected class FloatFocusListener
    extends FocusAdapter {
        protected FloatFocusListener() {
        }

        public void focusLost(FocusEvent fe) {
            Text text = (Text)fe.widget;
            String oldText = text.getText();
            try {
                String newText = Float.toString(Float.parseFloat(oldText));
                if (!oldText.equals(newText)) {
                    text.setText(newText);
                }
                FloatFieldEditor.this.valueChanged();
            }
            catch (Exception e) {
                log.log(Level.FINE, "Cannot change the value of the field:", e);
            }
        }
    }
}

