/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.preference.field;

import io.github.albertus82.jface.JFaceMessages;
import io.github.albertus82.jface.preference.field.FieldEditorDefault;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;

public class ListFieldEditor
extends FieldEditor
implements FieldEditorDefault {
    private static final int DEFAULT_HEIGHT = 4;
    private final String[][] entryNamesAndValues;
    private final int height;
    private List list;
    private String fValue;
    private boolean defaultToolTip = true;

    public ListFieldEditor(String name, String labelText, String[][] entryNamesAndValues, Composite parent) {
        this(name, labelText, entryNamesAndValues, 4, parent);
    }

    public ListFieldEditor(String name, String labelText, String[][] entryNamesAndValues, int height, Composite parent) {
        this.init(name, labelText);
        Assert.isTrue((boolean)this.checkArray(entryNamesAndValues));
        this.entryNamesAndValues = entryNamesAndValues;
        this.height = height;
        this.createControl(parent);
    }

    protected boolean checkArray(String[][] table) {
        if (table == null) {
            return false;
        }
        for (int i = 0; i < table.length; ++i) {
            String[] array = table[i];
            if (array != null && array.length == 2) continue;
            return false;
        }
        return true;
    }

    protected void adjustForNumColumns(int numColumns) {
        GridData gd = (GridData)this.list.getLayoutData();
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = gd.horizontalSpan == 1;
    }

    public int getNumberOfControls() {
        return 2;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelControl(parent);
        this.list = this.getListControl(parent);
        GridDataFactory.swtDefaults().span(numColumns - 1, 1).align(4, 0x1000000).grab(true, false).hint(-1, this.list.getItemHeight() * this.height).applyTo((Control)this.list);
        this.list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ListFieldEditor.this.list != null && ListFieldEditor.this.list.getSelectionCount() == 1) {
                    ListFieldEditor.this.fValue = ListFieldEditor.this.entryNamesAndValues[ListFieldEditor.this.list.getSelectionIndex()][1];
                }
            }
        });
    }

    protected void createControl(Composite parent) {
        super.createControl(parent);
        for (String[] pair : this.entryNamesAndValues) {
            this.list.add(pair[0]);
        }
    }

    protected List getListControl(Composite parent) {
        if (this.list == null) {
            this.list = new List(parent, 2564);
        } else {
            this.checkParent((Control)this.list, parent);
        }
        return this.list;
    }

    protected void doLoad() {
        this.updateComboForValue(this.getPreferenceStore().getString(this.getPreferenceName()));
        this.setToolTipText();
    }

    protected void doLoadDefault() {
        this.updateComboForValue(this.getDefaultValue());
    }

    protected void updateComboForValue(String value) {
        this.fValue = value;
        for (int i = 0; i < this.entryNamesAndValues.length; ++i) {
            if (!value.equals(this.entryNamesAndValues[i][1])) continue;
            this.list.setSelection(new String[]{this.entryNamesAndValues[i][0]});
            return;
        }
        if (this.entryNamesAndValues.length > 0) {
            this.fValue = this.entryNamesAndValues[0][1];
            this.list.setSelection(new String[]{this.entryNamesAndValues[0][0]});
        }
    }

    protected void doStore() {
        if (this.fValue == null) {
            this.getPreferenceStore().setToDefault(this.getPreferenceName());
            return;
        }
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.fValue);
    }

    protected String getDefaultValue() {
        return this.getPreferenceStore().getDefaultString(this.getPreferenceName());
    }

    protected String getNameForValue(String value) {
        String[][] namesAndValues = this.getEntryNamesAndValues();
        for (int i = 0; i < namesAndValues.length; ++i) {
            String[] entry = namesAndValues[i];
            if (!value.equals(entry[1])) continue;
            return entry[0];
        }
        return namesAndValues[0][0];
    }

    protected void setToolTipText() {
        if (this.defaultToolTip && this.getDefaultValue() != null && !this.getDefaultValue().isEmpty()) {
            String defaultValue = this.getNameForValue(this.getDefaultValue());
            if (this.getListControl() != null && !this.getListControl().isDisposed() && defaultValue != null && !defaultValue.isEmpty()) {
                this.getListControl().setToolTipText(JFaceMessages.get("lbl.preferences.default.value", defaultValue));
            }
        }
    }

    protected List getListControl() {
        return this.list;
    }

    @Override
    public boolean isDefaultToolTip() {
        return this.defaultToolTip;
    }

    @Override
    public void setDefaultToolTip(boolean defaultToolTip) {
        this.defaultToolTip = defaultToolTip;
    }

    @Override
    public boolean isBoldCustomValues() {
        return false;
    }

    @Override
    public void setBoldCustomValues(boolean boldCustomValues) {
    }

    public String getValue() {
        return this.fValue;
    }

    public void setValue(String value) {
        this.fValue = value;
    }

    public String[][] getEntryNamesAndValues() {
        return this.entryNamesAndValues;
    }

    public int getHeight() {
        return this.height;
    }
}

