/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertus82.jface.preference.field;

import io.github.albertus82.jface.JFaceMessages;
import io.github.albertus82.util.ISupplier;
import java.io.File;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.PathEditor;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;

public class LocalizedPathEditor
extends PathEditor {
    private boolean localized;
    private final boolean container;
    private String lastPath;
    private ISupplier<String> dirChooserLabelText;

    protected LocalizedPathEditor() {
        this.container = false;
    }

    public LocalizedPathEditor(String name, String labelText, ISupplier<String> dirChooserLabelText, Composite parent) {
        this(name, labelText, dirChooserLabelText, parent, null);
    }

    public LocalizedPathEditor(String name, String labelText, ISupplier<String> dirChooserLabelText, Composite parent, Integer horizontalSpan) {
        super(name, labelText, dirChooserLabelText != null ? dirChooserLabelText.get() : null, horizontalSpan != null && horizontalSpan > 0 ? LocalizedPathEditor.createContainer(parent, horizontalSpan) : parent);
        this.dirChooserLabelText = dirChooserLabelText;
        this.container = horizontalSpan != null && horizontalSpan > 0;
    }

    protected static Composite createContainer(Composite fieldEditorParent, int horizontalSpan) {
        Composite parent = new Composite(fieldEditorParent, 0);
        GridDataFactory.swtDefaults().align(4, 0x1000000).span(horizontalSpan, 1).applyTo((Control)parent);
        return parent;
    }

    protected void checkParent(Control control, Composite parent) {
        super.checkParent((Control)(this.container ? control.getParent() : control), parent);
    }

    public Composite getButtonBoxControl(Composite parent) {
        Composite buttonBox = super.getButtonBoxControl(parent);
        if (!this.localized) {
            Button addButton = this.getAddButton();
            addButton.setText(JFaceMessages.get("lbl.preferences.list.button.add"));
            Button removeButton = this.getRemoveButton();
            removeButton.setText(JFaceMessages.get("lbl.preferences.list.button.remove"));
            Button upButton = this.getUpButton();
            upButton.setText(JFaceMessages.get("lbl.preferences.list.button.up"));
            Button downButton = this.getDownButton();
            downButton.setText(JFaceMessages.get("lbl.preferences.list.button.down"));
            this.localized = true;
        }
        return buttonBox;
    }

    protected String getNewInputObject() {
        String dir;
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 0x10000000);
        if (this.dirChooserLabelText != null && this.dirChooserLabelText.get() != null) {
            dialog.setMessage(this.dirChooserLabelText.get());
        }
        if (this.lastPath != null && new File(this.lastPath).exists()) {
            dialog.setFilterPath(this.lastPath);
        }
        if ((dir = dialog.open()) != null) {
            if ((dir = dir.trim()).length() == 0) {
                return null;
            }
            this.lastPath = dir;
        }
        return dir;
    }
}

